/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.springutils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="componentContainer")
public class ComponentContainer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_ROLE_HINT = "default";
    public static final String BEAN_NAME_ROLEHINTSEPARATOR = "#";
    private Map<String, Map<String, ?>> classBeansOfType = new ConcurrentHashMap();
    @Inject
    protected ApplicationContext applicationContext;

    public String getDefaultRoleHint() {
        return DEFAULT_ROLE_HINT;
    }

    public <T> T getComponent(Class<T> clazz) {
        Map beansOfType = this.applicationContext.getBeansOfType(clazz);
        if (beansOfType == null || beansOfType.isEmpty()) {
            throw new RuntimeException("no beans of Type " + clazz.getName());
        }
        if (beansOfType.size() > 1) {
            throw new RuntimeException("not only one beans of Type " + clazz.getName());
        }
        return (T)beansOfType.values().iterator().next();
    }

    public <T> T getComponent(Class<T> clazz, String hint) {
        Map<String, T> beansOfType = this.buildMapWithRole(clazz);
        if (beansOfType == null || beansOfType.isEmpty()) {
            throw new RuntimeException("no beans of Type " + clazz.getName());
        }
        T bean = beansOfType.get(hint);
        if (bean == null) {
            throw new RuntimeException("no beans of Type " + clazz.getName() + " with hint " + hint);
        }
        return bean;
    }

    public <T> boolean hasComponent(Class<T> clazz) {
        Map beansOfType = this.applicationContext.getBeansOfType(clazz);
        if (beansOfType == null || beansOfType.isEmpty()) {
            return false;
        }
        return beansOfType.size() == 1;
    }

    public <T> boolean hasComponent(Class<T> clazz, String hint) {
        Map<String, T> beansOfType = this.buildMapWithRole(clazz);
        if (beansOfType == null || beansOfType.isEmpty()) {
            return false;
        }
        return beansOfType.containsKey(hint);
    }

    public <T> Map<String, T> buildMapWithRole(Class<T> clazz) {
        try {
            Map<String, Object> beansOfType = this.classBeansOfType.get(clazz.getName());
            if (beansOfType == null) {
                Map map = this.applicationContext.getBeansOfType(clazz);
                beansOfType = ComponentContainer.buildMapWithRole(map);
                this.classBeansOfType.put(clazz.getName(), beansOfType);
            }
            return beansOfType;
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> Map<String, T> buildMapWithRole(Map<String, T> beansOfType) {
        if (beansOfType == null || beansOfType.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, T> beansOfHint = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : beansOfType.entrySet()) {
            int separatorIndex = StringUtils.indexOf((String)entry.getKey(), (char)'#');
            if (separatorIndex >= 0) {
                String hint = entry.getKey().substring(separatorIndex + 1, entry.getKey().length());
                beansOfHint.put(hint, beansOfType.get(entry.getKey()));
                continue;
            }
            beansOfHint.put(entry.getKey(), beansOfType.get(entry.getKey()));
        }
        return beansOfHint;
    }
}

