/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.configuration;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.components.evaluator.DefaultExpressionEvaluator;
import org.apache.archiva.redback.components.evaluator.EvaluatorException;
import org.apache.archiva.redback.components.evaluator.ExpressionSource;
import org.apache.archiva.redback.components.evaluator.sources.SystemPropertyExpressionSource;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryException;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.configuration.UserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="userConfiguration#redback")
public class DefaultUserConfiguration
implements UserConfiguration {
    private static final String DEFAULT_CONFIG_RESOURCE = "org/apache/archiva/redback/config-defaults.properties";
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private List<String> configs;
    private Registry lookupRegistry;
    private static final String PREFIX = "org.apache.archiva.redback";
    @Inject
    @Named(value="commons-configuration")
    private Registry registry;

    @Override
    @PostConstruct
    public void initialize() throws UserConfigurationException {
        try {
            this.performLegacyInitialization();
            try {
                this.registry.addConfigurationFromResource(DEFAULT_CONFIG_RESOURCE, PREFIX);
            }
            catch (RegistryException e) {
                ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    this.registry.addConfigurationFromResource(DEFAULT_CONFIG_RESOURCE, PREFIX);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(prevCl);
                }
            }
            this.lookupRegistry = this.registry.getSubset(PREFIX);
            this.log.debug("User configuration {}", (Object)this.lookupRegistry.dump());
        }
        catch (RegistryException e) {
            throw new UserConfigurationException(e.getMessage(), e);
        }
    }

    private void performLegacyInitialization() throws RegistryException {
        DefaultExpressionEvaluator evaluator = new DefaultExpressionEvaluator();
        evaluator.addExpressionSource((ExpressionSource)new SystemPropertyExpressionSource());
        if (this.configs != null) {
            if (!this.configs.isEmpty()) {
                this.log.warn("DEPRECATED: the <configs> elements is deprecated. Please configure the Redback registry instead");
            }
            for (String configName : this.configs) {
                try {
                    configName = evaluator.expand(configName);
                }
                catch (EvaluatorException e) {
                    this.log.warn("Unable to resolve configuration name: {}", (Object)e.getMessage(), (Object)e);
                }
                this.log.info("Attempting to find configuration [{}] (resolved to [{}])", (Object)configName, (Object)configName);
                this.registry.addConfigurationFromFile(new File(configName), PREFIX);
            }
        }
    }

    @Override
    public String getString(String key) {
        return this.lookupRegistry.getString(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        String value = this.lookupRegistry.getString(key, defaultValue);
        return value;
    }

    @Override
    public int getInt(String key) {
        return this.lookupRegistry.getInt(key);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.lookupRegistry.getInt(key, defaultValue);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.lookupRegistry.getBoolean(key);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.lookupRegistry.getBoolean(key, defaultValue);
    }

    @Override
    public List<String> getList(String key) {
        return this.lookupRegistry.getList(key);
    }

    @Override
    public String getConcatenatedList(String key, String defaultValue) {
        List<String> list = this.getList(key);
        if (!list.isEmpty()) {
            StringBuilder s = new StringBuilder();
            for (String value : list) {
                if (s.length() > 0) {
                    s.append(",");
                }
                s.append(value);
            }
            this.log.debug("getList for key {} return {}", (Object)key, (Object)s.toString());
            return s.toString();
        }
        this.log.debug("getList for key {} return {}", (Object)key, (Object)defaultValue);
        return defaultValue;
    }

    public List<String> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<String> configs) {
        this.configs = configs;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public Collection<String> getKeys() {
        return this.registry.getSubset(PREFIX).getFullKeys();
    }
}

