/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.taskqueue.execution;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.archiva.redback.components.taskqueue.Task;
import org.apache.archiva.redback.components.taskqueue.TaskQueue;
import org.apache.archiva.redback.components.taskqueue.execution.TaskExecutionException;
import org.apache.archiva.redback.components.taskqueue.execution.TaskExecutor;
import org.apache.archiva.redback.components.taskqueue.execution.TaskQueueExecutor;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedTaskQueueExecutor
implements TaskQueueExecutor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int SHUTDOWN = 1;
    private static final int CANCEL_TASK = 2;
    private TaskQueue queue;
    private TaskExecutor executor;
    private String name;
    private ExecutorRunnable executorRunnable;
    private ExecutorService executorService;
    private Task currentTask;

    @PostConstruct
    public void start() {
        if (StringUtils.isBlank((String)this.name)) {
            throw new IllegalArgumentException("'name' must be set.");
        }
        this.logger.info("Starting task executor, thread name '{}'.", (Object)this.name);
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorRunnable = new ExecutorRunnable();
        this.executorRunnable.setDaemon(true);
        this.executorRunnable.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        this.executorRunnable.shutdown();
        int maxSleep = 10000;
        int interval = 1000;
        long endTime = System.currentTimeMillis() + (long)maxSleep;
        while (!this.executorRunnable.isDone() && this.executorRunnable.isAlive()) {
            if (System.currentTimeMillis() > endTime) {
                this.logger.warn("Timeout waiting for executor thread '{}' to stop, aborting", (Object)this.name);
                break;
            }
            this.logger.info("Waiting until task executor '{}' is idling...", (Object)this.name);
            try {
                ExecutorRunnable executorRunnable = this.executorRunnable;
                synchronized (executorRunnable) {
                    this.executorRunnable.wait(interval);
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.executorRunnable.shutdown();
        }
    }

    public Task getCurrentTask() {
        return this.currentTask;
    }

    public synchronized boolean cancelTask(Task task) {
        return this.executorRunnable.cancelTask(task);
    }

    public TaskQueue getQueue() {
        return this.queue;
    }

    public void setQueue(TaskQueue queue) {
        this.queue = queue;
    }

    public TaskExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(TaskExecutor executor) {
        this.executor = executor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private class ExecutorRunnable
    extends Thread {
        private volatile int command;
        private boolean done;

        private ExecutorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.command != 1) {
                Object task;
                ThreadedTaskQueueExecutor.this.currentTask = null;
                try {
                    task = ThreadedTaskQueueExecutor.this.queue.poll(100, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    ThreadedTaskQueueExecutor.this.logger.info("Executor thread interrupted, command: {}", (Object)(this.command == 1 ? "Shutdown" : (this.command == 2 ? "Cancel task" : "Unknown")));
                    continue;
                }
                if (task == null) continue;
                ThreadedTaskQueueExecutor.this.currentTask = task;
                Future<?> future = ThreadedTaskQueueExecutor.this.executorService.submit(new Runnable((Task)task){
                    final /* synthetic */ Task val$task;
                    {
                        this.val$task = task;
                    }

                    @Override
                    public void run() {
                        try {
                            ThreadedTaskQueueExecutor.this.executor.executeTask(this.val$task);
                        }
                        catch (TaskExecutionException e) {
                            ThreadedTaskQueueExecutor.this.logger.error("Error executing task", (Throwable)e);
                        }
                    }
                });
                try {
                    this.waitForTask((Task)task, future);
                }
                catch (ExecutionException e) {
                    ThreadedTaskQueueExecutor.this.logger.error("Error executing task", (Throwable)e);
                }
            }
            ThreadedTaskQueueExecutor.this.currentTask = null;
            ThreadedTaskQueueExecutor.this.logger.info("Executor thread '{}' exited.", (Object)ThreadedTaskQueueExecutor.this.name);
            this.done = true;
            ExecutorRunnable executorRunnable = this;
            synchronized (executorRunnable) {
                this.notifyAll();
            }
        }

        private void waitForTask(Task task, Future future) throws ExecutionException {
            boolean stop = false;
            while (!stop) {
                try {
                    if (task.getMaxExecutionTime() == 0L) {
                        ThreadedTaskQueueExecutor.this.logger.debug("Waiting indefinitely for task to complete");
                        future.get();
                        return;
                    }
                    ThreadedTaskQueueExecutor.this.logger.debug("Waiting at most {} ms for task completion", (Object)task.getMaxExecutionTime());
                    future.get(task.getMaxExecutionTime(), TimeUnit.MILLISECONDS);
                    ThreadedTaskQueueExecutor.this.logger.debug("Task completed within {} ms", (Object)task.getMaxExecutionTime());
                    return;
                }
                catch (InterruptedException e) {
                    switch (this.command) {
                        case 1: {
                            ThreadedTaskQueueExecutor.this.logger.info("Shutdown command received. Cancelling task.");
                            this.cancel(future);
                            return;
                        }
                        case 2: {
                            this.command = 0;
                            ThreadedTaskQueueExecutor.this.logger.info("Cancelling task");
                            this.cancel(future);
                            return;
                        }
                    }
                    ThreadedTaskQueueExecutor.this.logger.warn("Interrupted while waiting for task to complete; ignoring", (Throwable)e);
                }
                catch (TimeoutException e) {
                    ThreadedTaskQueueExecutor.this.logger.warn("Task {} didn't complete within time, cancelling it.", (Object)task);
                    this.cancel(future);
                    return;
                }
                catch (CancellationException e) {
                    ThreadedTaskQueueExecutor.this.logger.warn("The task was cancelled", (Throwable)e);
                    return;
                }
            }
        }

        private void cancel(Future future) {
            if (!future.cancel(true)) {
                if (!future.isDone() && !future.isCancelled()) {
                    ThreadedTaskQueueExecutor.this.logger.warn("Unable to cancel task");
                } else {
                    ThreadedTaskQueueExecutor.this.logger.warn("Task not cancelled (Flags: done: {} cancelled: {})", (Object)future.isDone(), (Object)future.isCancelled());
                }
            } else {
                ThreadedTaskQueueExecutor.this.logger.debug("Task successfully cancelled");
            }
        }

        public synchronized void shutdown() {
            ThreadedTaskQueueExecutor.this.logger.debug("Signalling executor thread to shutdown");
            this.command = 1;
            this.interrupt();
        }

        public synchronized boolean cancelTask(Task task) {
            if (!task.equals(ThreadedTaskQueueExecutor.this.currentTask)) {
                ThreadedTaskQueueExecutor.this.logger.debug("Not cancelling task - it is not running");
                return false;
            }
            if (this.command != 1) {
                ThreadedTaskQueueExecutor.this.logger.debug("Signalling executor thread to cancel task");
                this.command = 2;
                this.interrupt();
            } else {
                ThreadedTaskQueueExecutor.this.logger.debug("Executor thread already stopping; task will be cancelled automatically");
            }
            return true;
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

