/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.users.configurable;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.users.AbstractUserManager;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.archiva.redback.users.UserQuery;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="userManager#configurable")
public class ConfigurableUserManager
extends AbstractUserManager
implements UserManager {
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration config;
    @Inject
    private ApplicationContext applicationContext;
    private UserManager userManagerImpl;

    @PostConstruct
    public void initialize() {
        String userManagerRole = this.config.getString("user.manager.impl");
        if (userManagerRole == null) {
            throw new RuntimeException("User Manager Configuration Missing: user.manager.impl configuration property");
        }
        this.log.info("use userManager impl with key: '{}'", (Object)userManagerRole);
        this.userManagerImpl = (UserManager)this.applicationContext.getBean("userManager#" + userManagerRole, UserManager.class);
    }

    public User addUser(User user) throws UserManagerException {
        return this.userManagerImpl.addUser(user);
    }

    public void addUserUnchecked(User user) throws UserManagerException {
        this.userManagerImpl.addUserUnchecked(user);
    }

    public User createUser(String username, String fullName, String emailAddress) throws UserManagerException {
        return this.userManagerImpl.createUser(username, fullName, emailAddress);
    }

    public UserQuery createUserQuery() {
        return this.userManagerImpl.createUserQuery();
    }

    public void deleteUser(String username) throws UserNotFoundException, UserManagerException {
        this.userManagerImpl.deleteUser(username);
    }

    public void eraseDatabase() {
        this.userManagerImpl.eraseDatabase();
    }

    public User findUser(String username) throws UserManagerException, UserNotFoundException {
        return this.userManagerImpl.findUser(username);
    }

    public User findUser(String username, boolean useCache) throws UserNotFoundException, UserManagerException {
        return this.userManagerImpl.findUser(username, useCache);
    }

    public User getGuestUser() throws UserNotFoundException, UserManagerException {
        return this.userManagerImpl.getGuestUser();
    }

    public List<User> findUsersByEmailKey(String emailKey, boolean orderAscending) throws UserManagerException {
        return this.userManagerImpl.findUsersByEmailKey(emailKey, orderAscending);
    }

    public List<User> findUsersByFullNameKey(String fullNameKey, boolean orderAscending) throws UserManagerException {
        return this.userManagerImpl.findUsersByFullNameKey(fullNameKey, orderAscending);
    }

    public List<User> findUsersByQuery(UserQuery query) throws UserManagerException {
        return this.userManagerImpl.findUsersByQuery(query);
    }

    public List<User> findUsersByUsernameKey(String usernameKey, boolean orderAscending) throws UserManagerException {
        return this.userManagerImpl.findUsersByUsernameKey(usernameKey, orderAscending);
    }

    public String getId() {
        return "configurable";
    }

    public List<User> getUsers() throws UserManagerException {
        return this.userManagerImpl.getUsers();
    }

    public List<User> getUsers(boolean orderAscending) throws UserManagerException {
        return this.userManagerImpl.getUsers(orderAscending);
    }

    public boolean isReadOnly() {
        return this.userManagerImpl.isReadOnly();
    }

    public User updateUser(User user) throws UserNotFoundException, UserManagerException {
        return this.updateUser(user, false);
    }

    public User updateUser(User user, boolean passwordChangeRequired) throws UserNotFoundException, UserManagerException {
        return this.userManagerImpl.updateUser(user, passwordChangeRequired);
    }

    public boolean userExists(String userName) throws UserManagerException {
        return this.userManagerImpl.userExists(userName);
    }

    public void setUserManagerImpl(UserManager userManagerImpl) {
        this.userManagerImpl = userManagerImpl;
    }

    public String getDescriptionKey() {
        return "archiva.redback.usermanager.configurable";
    }
}

