/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.commons.AbstractRepository;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientRepository
extends AbstractRepository
implements JackrabbitRepository,
SessionListener {
    private static final Logger logger = LoggerFactory.getLogger(TransientRepository.class);
    private static final String CONF_PROPERTY = "org.apache.jackrabbit.repository.conf";
    private static final String CONF_DEFAULT = "repository.xml";
    private static final String HOME_PROPERTY = "org.apache.jackrabbit.repository.home";
    private static final String HOME_DEFAULT = "repository";
    private final RepositoryFactory factory;
    private RepositoryImpl repository;
    private final Map<Session, Session> sessions = new ReferenceMap(2, 2);
    private final Properties descriptors;
    private final String home;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransientRepository(RepositoryFactory factory, String home) {
        this.factory = factory;
        this.home = home;
        this.repository = null;
        this.descriptors = new Properties();
        try {
            InputStream in = RepositoryImpl.class.getResourceAsStream("repository.properties");
            try {
                this.descriptors.load(in);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            logger.warn("Unable to load static repository descriptors", (Throwable)e);
        }
    }

    public TransientRepository() {
        this(System.getProperty(CONF_PROPERTY, CONF_DEFAULT), System.getProperty(HOME_PROPERTY, HOME_DEFAULT));
    }

    public TransientRepository(final RepositoryConfig config) {
        this(new RepositoryFactory(){

            @Override
            public RepositoryImpl getRepository() throws RepositoryException {
                return RepositoryImpl.create(RepositoryConfig.create(config));
            }
        }, config.getHomeDir());
    }

    public TransientRepository(String config, String home) {
        this(new File(config), new File(home));
    }

    public TransientRepository(File dir) {
        this(new File(dir, CONF_DEFAULT), dir);
    }

    public TransientRepository(final File xml, final File dir) {
        this(new RepositoryFactory(){

            @Override
            public RepositoryImpl getRepository() throws RepositoryException {
                try {
                    return RepositoryImpl.create(RepositoryConfig.install(xml, dir));
                }
                catch (IOException e) {
                    throw new RepositoryException("Automatic repository configuration failed", (Throwable)e);
                }
                catch (ConfigurationException e) {
                    throw new RepositoryException("Invalid repository configuration file: " + xml, (Throwable)e);
                }
            }
        }, dir.getAbsolutePath());
    }

    public TransientRepository(final Properties properties) throws ConfigurationException, IOException {
        this(new RepositoryFactory(){

            @Override
            public RepositoryImpl getRepository() throws RepositoryException {
                try {
                    return RepositoryImpl.create(RepositoryConfig.install(properties));
                }
                catch (IOException e) {
                    throw new RepositoryException("Automatic repository configuration failed: " + properties, (Throwable)e);
                }
                catch (ConfigurationException e) {
                    throw new RepositoryException("Invalid repository configuration: " + properties, (Throwable)e);
                }
            }
        }, RepositoryConfig.getRepositoryHome(properties).getAbsolutePath());
    }

    public String getHomeDir() {
        return this.home;
    }

    private synchronized void startRepository() throws RepositoryException {
        assert (this.repository == null && this.sessions.isEmpty());
        logger.debug("Initializing transient repository");
        this.repository = this.factory.getRepository();
        logger.info("Transient repository initialized");
    }

    private synchronized void stopRepository() {
        assert (this.repository != null && this.sessions.isEmpty());
        logger.debug("Shutting down transient repository");
        this.repository.shutdown();
        logger.info("Transient repository shut down");
        this.repository = null;
    }

    public synchronized String[] getDescriptorKeys() {
        if (this.repository != null) {
            return this.repository.getDescriptorKeys();
        }
        Object[] keys = Collections.list(this.descriptors.propertyNames()).toArray(new String[0]);
        Arrays.sort(keys);
        return keys;
    }

    public synchronized String getDescriptor(String key) {
        if (this.repository != null) {
            return this.repository.getDescriptor(key);
        }
        return this.descriptors.getProperty(key);
    }

    public Value getDescriptorValue(String key) {
        if (this.repository != null) {
            return this.repository.getDescriptorValue(key);
        }
        throw new UnsupportedOperationException("not implemented yet - see JCR-2062");
    }

    public Value[] getDescriptorValues(String key) {
        if (this.repository != null) {
            return this.repository.getDescriptorValues(key);
        }
        throw new UnsupportedOperationException("not implemented yet - see JCR-2062");
    }

    public boolean isSingleValueDescriptor(String key) {
        if (this.repository != null) {
            return this.repository.isSingleValueDescriptor(key);
        }
        throw new UnsupportedOperationException("not implemented yet - see JCR-2062");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Session login(Credentials credentials, String workspaceName) throws RepositoryException {
        if (this.repository == null) {
            this.startRepository();
        }
        try {
            logger.debug("Opening a new session");
            SessionImpl session = (SessionImpl)this.repository.login(credentials, workspaceName);
            this.sessions.put((Session)session, (Session)session);
            session.addListener(this);
            logger.info("Session opened");
            SessionImpl sessionImpl = session;
            return sessionImpl;
        }
        finally {
            if (this.sessions.isEmpty()) {
                this.stopRepository();
            }
        }
    }

    public synchronized void shutdown() {
        Session[] copy;
        for (Session session : copy = this.sessions.keySet().toArray(new Session[0])) {
            session.logout();
        }
    }

    @Override
    public synchronized void loggedOut(SessionImpl session) {
        assert (this.sessions.containsKey((Object)session));
        this.sessions.remove((Object)session);
        logger.info("Session closed");
        if (this.sessions.isEmpty()) {
            this.repository.loggedOut(session);
            this.stopRepository();
        }
    }

    @Override
    public void loggingOut(SessionImpl session) {
    }

    RepositoryImpl getRepository() {
        return this.repository;
    }

    public static interface RepositoryFactory {
        public RepositoryImpl getRepository() throws RepositoryException;
    }
}

