/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.evaluator;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.archiva.redback.components.evaluator.EvaluatorException;
import org.apache.archiva.redback.components.evaluator.ExpressionEvaluator;
import org.apache.archiva.redback.components.evaluator.ExpressionSource;
import org.codehaus.plexus.util.StringUtils;

public class DefaultExpressionEvaluator
implements ExpressionEvaluator {
    private List expressionSources = new ArrayList();

    @Override
    public void addExpressionSource(ExpressionSource source) {
        this.expressionSources.add(source);
    }

    @Override
    public String expand(String str) throws EvaluatorException {
        return this.recursiveExpand(str, new ArrayList());
    }

    private String recursiveExpand(String str, List seenExpressions) throws EvaluatorException {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        if (str.indexOf("${") < 0) {
            return str;
        }
        if (this.expressionSources.isEmpty()) {
            throw new EvaluatorException("Unable to expand expressions with empty ExpressionSource list.");
        }
        Pattern pat = Pattern.compile("(?<=[^$]|^)(\\$\\{[^}]*\\})");
        Matcher mat = pat.matcher(str);
        int offset = 0;
        StringBuilder expanded = new StringBuilder();
        while (mat.find(offset)) {
            String expression = mat.group(1);
            if (seenExpressions.contains(expression)) {
                throw new EvaluatorException("A recursive cycle has been detected with expression " + expression + ".");
            }
            seenExpressions.add(expression);
            expanded.append(str.substring(offset, mat.start(1)));
            String value = this.findValue(expression);
            if (value != null) {
                String resolvedValue = this.recursiveExpand(value, seenExpressions);
                expanded.append(resolvedValue);
            } else {
                expanded.append(expression);
            }
            offset = mat.end(1);
        }
        expanded.append(str.substring(offset));
        if (expanded.indexOf("$$") >= 0) {
            return expanded.toString().replaceAll("\\$\\$", "\\$");
        }
        return expanded.toString();
    }

    private String findValue(String expression) {
        String newExpression = expression.trim();
        if (newExpression.startsWith("${") && newExpression.endsWith("}")) {
            newExpression = newExpression.substring(2, newExpression.length() - 1);
        }
        if (StringUtils.isEmpty((String)newExpression)) {
            return null;
        }
        String value = null;
        for (ExpressionSource source : this.expressionSources) {
            value = source.getExpressionValue(newExpression);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public List getExpressionSourceList() {
        return this.expressionSources;
    }

    @Override
    public boolean removeExpressionSource(ExpressionSource source) {
        return this.expressionSources.remove(source);
    }
}

