/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rbac;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManagerListener;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.RbacObjectInvalidException;
import org.apache.archiva.redback.rbac.RbacObjectNotFoundException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;

public interface RBACManager {
    public void addListener(RBACManagerListener var1);

    public void removeListener(RBACManagerListener var1);

    public Role createRole(String var1);

    public boolean roleExists(String var1) throws RbacManagerException;

    public boolean roleExists(Role var1) throws RbacManagerException;

    public Role saveRole(Role var1) throws RbacObjectInvalidException, RbacManagerException;

    public void saveRoles(Collection<Role> var1) throws RbacObjectInvalidException, RbacManagerException;

    public Role getRole(String var1) throws RbacObjectNotFoundException, RbacManagerException;

    public Map<String, Role> getRoles(Collection<String> var1) throws RbacObjectNotFoundException, RbacManagerException;

    public void addChildRole(Role var1, Role var2) throws RbacObjectInvalidException, RbacManagerException;

    public Map<String, Role> getChildRoles(Role var1) throws RbacManagerException;

    public Map<String, Role> getParentRoles(Role var1) throws RbacManagerException;

    public List<Role> getAllRoles() throws RbacManagerException;

    public Set<Role> getEffectiveRoles(Role var1) throws RbacObjectNotFoundException, RbacManagerException;

    public void removeRole(Role var1) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException;

    public void removeRole(String var1) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException;

    public Permission createPermission(String var1) throws RbacManagerException;

    public Permission createPermission(String var1, String var2, String var3) throws RbacManagerException;

    public boolean permissionExists(String var1);

    public boolean permissionExists(Permission var1);

    public Permission savePermission(Permission var1) throws RbacObjectInvalidException, RbacManagerException;

    public Permission getPermission(String var1) throws RbacObjectNotFoundException, RbacManagerException;

    public List<Permission> getAllPermissions() throws RbacManagerException;

    public void removePermission(Permission var1) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException;

    public void removePermission(String var1) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException;

    public Operation createOperation(String var1) throws RbacManagerException;

    public boolean operationExists(String var1);

    public boolean operationExists(Operation var1);

    public Operation saveOperation(Operation var1) throws RbacObjectInvalidException, RbacManagerException;

    public Operation getOperation(String var1) throws RbacObjectNotFoundException, RbacManagerException;

    public List<Operation> getAllOperations() throws RbacManagerException;

    public void removeOperation(Operation var1) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException;

    public void removeOperation(String var1) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException;

    public Resource createResource(String var1) throws RbacManagerException;

    public boolean resourceExists(String var1);

    public boolean resourceExists(Resource var1);

    public Resource saveResource(Resource var1) throws RbacObjectInvalidException, RbacManagerException;

    public Resource getResource(String var1) throws RbacObjectNotFoundException, RbacManagerException;

    public List<Resource> getAllResources() throws RbacManagerException;

    public void removeResource(Resource var1) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException;

    public void removeResource(String var1) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException;

    public UserAssignment createUserAssignment(String var1) throws RbacManagerException;

    public boolean userAssignmentExists(String var1);

    public boolean userAssignmentExists(UserAssignment var1);

    public UserAssignment saveUserAssignment(UserAssignment var1) throws RbacObjectInvalidException, RbacManagerException;

    public UserAssignment getUserAssignment(String var1) throws RbacObjectNotFoundException, RbacManagerException;

    public List<UserAssignment> getAllUserAssignments() throws RbacManagerException;

    public List<UserAssignment> getUserAssignmentsForRoles(Collection<String> var1) throws RbacManagerException;

    public void removeUserAssignment(UserAssignment var1) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException;

    public void removeUserAssignment(String var1) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException;

    public Collection<Role> getAssignedRoles(String var1) throws RbacObjectNotFoundException, RbacManagerException;

    public Collection<Role> getAssignedRoles(UserAssignment var1) throws RbacObjectNotFoundException, RbacManagerException;

    public Collection<Role> getEffectivelyUnassignedRoles(String var1) throws RbacManagerException, RbacObjectNotFoundException;

    public Collection<Role> getEffectivelyAssignedRoles(String var1) throws RbacObjectNotFoundException, RbacManagerException;

    public Collection<Role> getUnassignedRoles(String var1) throws RbacManagerException, RbacObjectNotFoundException;

    public Set<Permission> getAssignedPermissions(String var1) throws RbacObjectNotFoundException, RbacManagerException;

    public Map<String, List<Permission>> getAssignedPermissionMap(String var1) throws RbacObjectNotFoundException, RbacManagerException;

    public List<Role> getAllAssignableRoles() throws RbacManagerException, RbacObjectNotFoundException;

    public Resource getGlobalResource() throws RbacManagerException;

    public void eraseDatabase();

    public void initialize();

    public boolean isFinalImplementation();

    public String getDescriptionKey();

    public boolean isReadOnly();
}

