/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rbac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RBACManagerListener;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.RbacObjectInvalidException;
import org.apache.archiva.redback.rbac.RbacObjectNotFoundException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRBACManager
implements RBACManager {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private List<RBACManagerListener> listeners = new ArrayList<RBACManagerListener>(0);
    private Resource globalResource;

    @Override
    @PostConstruct
    public void initialize() {
    }

    @Override
    public boolean isFinalImplementation() {
        return false;
    }

    @Override
    public void addListener(RBACManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(RBACManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void fireRbacInit(boolean freshdb) {
        for (RBACManagerListener listener : this.listeners) {
            try {
                listener.rbacInit(freshdb);
            }
            catch (Exception e) {
                this.log.warn("Unable to trigger .rbacInit( boolean ) to {}", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    public void fireRbacRoleSaved(Role role) {
        for (RBACManagerListener listener : this.listeners) {
            try {
                listener.rbacRoleSaved(role);
            }
            catch (Exception e) {
                this.log.warn("Unable to trigger .rbacRoleSaved( Role ) to {}", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    public void fireRbacRoleRemoved(Role role) {
        for (RBACManagerListener listener : this.listeners) {
            try {
                listener.rbacRoleRemoved(role);
            }
            catch (Exception e) {
                this.log.warn("Unable to trigger .rbacRoleRemoved( Role ) to {}", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    public void fireRbacPermissionSaved(Permission permission) {
        for (RBACManagerListener listener : this.listeners) {
            try {
                listener.rbacPermissionSaved(permission);
            }
            catch (Exception e) {
                this.log.warn("Unable to trigger .rbacPermissionSaved( Permission ) to {}", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    public void fireRbacPermissionRemoved(Permission permission) {
        for (RBACManagerListener listener : this.listeners) {
            try {
                listener.rbacPermissionRemoved(permission);
            }
            catch (Exception e) {
                this.log.warn("Unable to trigger .rbacPermissionRemoved( Permission ) to {}", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    public void fireRbacUserAssignmentSaved(UserAssignment userAssignment) {
        for (RBACManagerListener listener : this.listeners) {
            try {
                listener.rbacUserAssignmentSaved(userAssignment);
            }
            catch (Exception e) {
                this.log.warn("Unable to trigger .rbacUserAssignmentSaved( UserAssignment ) to {}", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    public void fireRbacUserAssignmentRemoved(UserAssignment userAssignment) {
        for (RBACManagerListener listener : this.listeners) {
            try {
                listener.rbacUserAssignmentRemoved(userAssignment);
            }
            catch (Exception e) {
                this.log.warn("Unable to trigger .rbacUserAssignmentRemoved( UserAssignment ) to {}", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    public void removeRole(String roleName) throws RbacObjectNotFoundException, RbacManagerException {
        this.removeRole(this.getRole(roleName));
    }

    @Override
    public void removePermission(String permissionName) throws RbacObjectNotFoundException, RbacManagerException {
        this.removePermission(this.getPermission(permissionName));
    }

    @Override
    public void removeOperation(String operationName) throws RbacObjectNotFoundException, RbacManagerException {
        this.removeOperation(this.getOperation(operationName));
    }

    @Override
    public void removeResource(String resourceIdentifier) throws RbacObjectNotFoundException, RbacManagerException {
        this.removeResource(this.getResource(resourceIdentifier));
    }

    @Override
    public void removeUserAssignment(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        this.removeUserAssignment(this.getUserAssignment(principal));
    }

    @Override
    public boolean resourceExists(Resource resource) {
        try {
            return this.getAllResources().contains(resource);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    @Override
    public boolean resourceExists(String identifier) {
        try {
            for (Resource resource : this.getAllResources()) {
                if (!StringUtils.equals((String)resource.getIdentifier(), (String)identifier)) continue;
                return true;
            }
        }
        catch (RbacManagerException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean operationExists(Operation operation) {
        try {
            return this.getAllOperations().contains(operation);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    @Override
    public boolean operationExists(String name) {
        try {
            for (Operation operation : this.getAllOperations()) {
                if (!StringUtils.equals((String)operation.getName(), (String)name)) continue;
                return true;
            }
        }
        catch (RbacManagerException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean permissionExists(Permission permission) {
        try {
            return this.getAllPermissions().contains(permission);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    @Override
    public boolean permissionExists(String name) {
        try {
            for (Permission permission : this.getAllPermissions()) {
                if (!StringUtils.equals((String)permission.getName(), (String)name)) continue;
                return true;
            }
        }
        catch (RbacManagerException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean roleExists(Role role) throws RbacManagerException {
        try {
            return this.getAllRoles().contains(role);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    @Override
    public boolean roleExists(String name) throws RbacManagerException {
        try {
            for (Role role : this.getAllRoles()) {
                if (!StringUtils.equals((String)role.getName(), (String)name)) continue;
                return true;
            }
        }
        catch (RbacManagerException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean userAssignmentExists(String principal) {
        try {
            for (UserAssignment assignment : this.getAllUserAssignments()) {
                if (!StringUtils.equals((String)assignment.getPrincipal(), (String)principal)) continue;
                return true;
            }
        }
        catch (RbacManagerException e) {
            return false;
        }
        return false;
    }

    @Override
    public boolean userAssignmentExists(UserAssignment assignment) {
        try {
            return this.getAllUserAssignments().contains(assignment);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    @Override
    public Set<Permission> getAssignedPermissions(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        UserAssignment ua = this.getUserAssignment(principal);
        HashSet<Permission> permissionSet = new HashSet<Permission>();
        if (ua.getRoleNames() != null) {
            boolean childRoleNamesUpdated = false;
            ListIterator<String> it = ua.getRoleNames().listIterator();
            while (it.hasNext()) {
                String roleName = (String)it.next();
                try {
                    Role role = this.getRole(roleName);
                    this.gatherUniquePermissions(role, permissionSet);
                }
                catch (RbacObjectNotFoundException e) {
                    it.remove();
                    childRoleNamesUpdated = true;
                }
            }
            if (childRoleNamesUpdated) {
                this.saveUserAssignment(ua);
            }
        }
        return permissionSet;
    }

    @Override
    public Map<String, List<Permission>> getAssignedPermissionMap(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        return this.getPermissionMapByOperation(this.getAssignedPermissions(principal));
    }

    private Map<String, List<Permission>> getPermissionMapByOperation(Collection<Permission> permissions) {
        HashMap<String, List<Permission>> userPermMap = new HashMap<String, List<Permission>>();
        for (Permission permission : permissions) {
            List permList = (List)userPermMap.get(permission.getOperation().getName());
            if (permList != null) {
                permList.add(permission);
                continue;
            }
            ArrayList<Permission> newPermList = new ArrayList<Permission>(permissions.size());
            newPermList.add(permission);
            userPermMap.put(permission.getOperation().getName(), newPermList);
        }
        return userPermMap;
    }

    private void gatherUniquePermissions(Role role, Collection<Permission> coll) throws RbacManagerException {
        if (role.getPermissions() != null) {
            for (Permission permission : role.getPermissions()) {
                if (coll.contains(permission)) continue;
                coll.add(permission);
            }
        }
        if (role.hasChildRoles()) {
            Map<String, Role> childRoles = this.getChildRoles(role);
            for (Role child : childRoles.values()) {
                this.gatherUniquePermissions(child, coll);
            }
        }
    }

    @Override
    public List<Role> getAllAssignableRoles() throws RbacManagerException, RbacObjectNotFoundException {
        ArrayList<Role> assignableRoles = new ArrayList<Role>();
        for (Role r : this.getAllRoles()) {
            Role role = this.getRole(r.getName());
            if (!role.isAssignable()) continue;
            assignableRoles.add(role);
        }
        return assignableRoles;
    }

    @Override
    public Collection<Role> getAssignedRoles(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        UserAssignment ua = this.getUserAssignment(principal);
        return this.getAssignedRoles(ua);
    }

    @Override
    public Collection<Role> getAssignedRoles(UserAssignment ua) throws RbacObjectNotFoundException, RbacManagerException {
        HashSet<Role> roleSet = new HashSet<Role>();
        if (ua.getRoleNames() != null) {
            boolean childRoleNamesUpdated = false;
            ListIterator<String> it = ua.getRoleNames().listIterator();
            while (it.hasNext()) {
                String roleName = (String)it.next();
                try {
                    Role role = this.getRole(roleName);
                    if (roleSet.contains(role)) continue;
                    roleSet.add(role);
                }
                catch (RbacObjectNotFoundException e) {
                    it.remove();
                    childRoleNamesUpdated = true;
                }
            }
            if (childRoleNamesUpdated) {
                this.saveUserAssignment(ua);
            }
        }
        return roleSet;
    }

    private void gatherEffectiveRoles(Role role, Set<Role> roleSet) throws RbacObjectNotFoundException, RbacManagerException {
        if (role.hasChildRoles()) {
            for (String roleName : role.getChildRoleNames()) {
                try {
                    Role crole = this.getRole(roleName);
                    if (roleSet.contains(crole)) continue;
                    this.gatherEffectiveRoles(crole, roleSet);
                }
                catch (RbacObjectNotFoundException e) {
                    this.log.warn("dangling child role: {} on {}", (Object)roleName, (Object)role.getName());
                }
            }
        }
        if (!roleSet.contains(role)) {
            roleSet.add(role);
        }
    }

    @Override
    public Collection<Role> getEffectivelyAssignedRoles(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        UserAssignment ua = this.getUserAssignment(principal);
        return this.getEffectivelyAssignedRoles(ua);
    }

    public Collection<Role> getEffectivelyAssignedRoles(UserAssignment ua) throws RbacObjectNotFoundException, RbacManagerException {
        HashSet<Role> roleSet = new HashSet<Role>();
        if (ua != null && ua.getRoleNames() != null) {
            boolean childRoleNamesUpdated = false;
            ListIterator<String> it = ua.getRoleNames().listIterator();
            while (it.hasNext()) {
                String roleName = (String)it.next();
                try {
                    Role role = this.getRole(roleName);
                    this.gatherEffectiveRoles(role, roleSet);
                }
                catch (RbacObjectNotFoundException e) {
                    it.remove();
                    childRoleNamesUpdated = true;
                }
            }
            if (childRoleNamesUpdated) {
                this.saveUserAssignment(ua);
            }
        }
        return roleSet;
    }

    @Override
    public Collection<Role> getEffectivelyUnassignedRoles(String principal) throws RbacManagerException, RbacObjectNotFoundException {
        Collection<Role> assignedRoles = this.getEffectivelyAssignedRoles(principal);
        List<Role> allRoles = this.getAllAssignableRoles();
        this.log.debug("UR: assigned {}", (Object)assignedRoles.size());
        this.log.debug("UR: available {}", (Object)allRoles.size());
        return CollectionUtils.subtract(allRoles, assignedRoles);
    }

    @Override
    public Collection<Role> getUnassignedRoles(String principal) throws RbacManagerException, RbacObjectNotFoundException {
        Collection<Role> assignedRoles = this.getAssignedRoles(principal);
        List<Role> allRoles = this.getAllAssignableRoles();
        this.log.debug("UR: assigned {}", (Object)assignedRoles.size());
        this.log.debug("UR: available {}", (Object)allRoles.size());
        return CollectionUtils.subtract(allRoles, assignedRoles);
    }

    @Override
    public Resource getGlobalResource() throws RbacManagerException {
        if (this.globalResource == null) {
            this.globalResource = this.createResource("*");
            this.globalResource.setPermanent(true);
            this.globalResource = this.saveResource(this.globalResource);
        }
        return this.globalResource;
    }

    @Override
    public void addChildRole(Role role, Role childRole) throws RbacObjectInvalidException, RbacManagerException {
        this.saveRole(childRole);
        role.addChildRoleName(childRole.getName());
    }

    @Override
    public Map<String, Role> getChildRoles(Role role) throws RbacManagerException {
        HashMap<String, Role> childRoles = new HashMap<String, Role>();
        boolean childRoleNamesUpdated = false;
        ListIterator<String> it = role.getChildRoleNames().listIterator();
        ArrayList<String> updatedChildRoleList = new ArrayList<String>(role.getChildRoleNames().size());
        while (it.hasNext()) {
            String roleName = (String)it.next();
            try {
                Role child = this.getRole(roleName);
                if (child != null) {
                    childRoles.put(child.getName(), child);
                    updatedChildRoleList.add(roleName);
                    continue;
                }
                this.log.warn("error searching role with name '{}' probably some issues when migrating your role manager", (Object)roleName);
            }
            catch (RbacObjectNotFoundException e) {
                childRoleNamesUpdated = true;
            }
            catch (RbacManagerException e) {
                if (!(e.getCause() instanceof RbacObjectNotFoundException)) {
                    throw e;
                }
                childRoleNamesUpdated = true;
            }
        }
        if (childRoleNamesUpdated) {
            role.setChildRoleNames(updatedChildRoleList);
            this.saveRole(role);
        }
        return childRoles;
    }

    @Override
    public Map<String, Role> getParentRoles(Role role) throws RbacManagerException {
        HashMap<String, Role> parentRoles = new HashMap<String, Role>();
        for (Role r : this.getAllRoles()) {
            if (r.getName().equals(role.getName())) continue;
            Set<Role> effectiveRoles = this.getEffectiveRoles(r);
            for (Role currentRole : effectiveRoles) {
                if (!currentRole.getName().equals(role.getName()) || parentRoles.containsKey(r.getName())) continue;
                parentRoles.put(r.getName(), r);
            }
        }
        return parentRoles;
    }

    @Override
    public Set<Role> getEffectiveRoles(Role role) throws RbacObjectNotFoundException, RbacManagerException {
        HashSet<Role> roleSet = new HashSet<Role>();
        this.gatherEffectiveRoles(role, roleSet);
        return roleSet;
    }

    @Override
    public Map<String, Role> getRoles(Collection<String> roleNames) throws RbacObjectNotFoundException, RbacManagerException {
        HashMap<String, Role> roleMap = new HashMap<String, Role>();
        for (String roleName : roleNames) {
            Role child = this.getRole(roleName);
            roleMap.put(child.getName(), child);
        }
        return roleMap;
    }
}

