/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = -141838337907252911L;
    protected static final QName ROOT_NAME_FOR_NULL = new QName("null");
    protected final XmlRootNameLookup _rootNameLookup;

    public XmlSerializerProvider(XmlRootNameLookup xmlRootNameLookup) {
        this._rootNameLookup = xmlRootNameLookup;
    }

    public XmlSerializerProvider(XmlSerializerProvider xmlSerializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        super((SerializerProvider)xmlSerializerProvider, serializationConfig, serializerFactory);
        this._rootNameLookup = xmlSerializerProvider._rootNameLookup;
    }

    public DefaultSerializerProvider createInstance(SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        return new XmlSerializerProvider(this, serializationConfig, serializerFactory);
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonProcessingException {
        QName qName;
        boolean bl;
        if (object == null) {
            this._serializeXmlNull(jsonGenerator);
            return;
        }
        Class<?> clazz = object.getClass();
        ToXmlGenerator toXmlGenerator = this._asXmlGenerator(jsonGenerator);
        if (toXmlGenerator == null) {
            bl = false;
        } else {
            qName = this._rootNameFromConfig();
            if (qName == null) {
                qName = this._rootNameLookup.findRootName(clazz, (MapperConfig<?>)this._config);
            }
            this._initWithRootName(toXmlGenerator, qName);
            bl = TypeUtil.isIndexedType(clazz);
            if (bl) {
                this._startRootArray(toXmlGenerator, qName);
            }
        }
        qName = this.findTypedValueSerializer(clazz, true, null);
        try {
            qName.serialize(object, jsonGenerator, (SerializerProvider)this);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            throw new JsonMappingException(string, (Throwable)exception);
        }
        if (bl) {
            jsonGenerator.writeEndObject();
        }
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType) throws IOException, JsonProcessingException {
        QName qName;
        boolean bl;
        if (object == null) {
            this._serializeXmlNull(jsonGenerator);
            return;
        }
        ToXmlGenerator toXmlGenerator = this._asXmlGenerator(jsonGenerator);
        if (toXmlGenerator == null) {
            bl = false;
        } else {
            qName = this._rootNameFromConfig();
            if (qName == null) {
                qName = this._rootNameLookup.findRootName(javaType, (MapperConfig<?>)this._config);
            }
            this._initWithRootName(toXmlGenerator, qName);
            bl = TypeUtil.isIndexedType(javaType);
            if (bl) {
                this._startRootArray(toXmlGenerator, qName);
            }
        }
        qName = this.findTypedValueSerializer(javaType, true, null);
        try {
            qName.serialize(object, jsonGenerator, (SerializerProvider)this);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            throw new JsonMappingException(string, (Throwable)exception);
        }
        if (bl) {
            jsonGenerator.writeEndObject();
        }
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer) throws IOException, JsonGenerationException {
        boolean bl;
        if (object == null) {
            this._serializeXmlNull(jsonGenerator);
            return;
        }
        ToXmlGenerator toXmlGenerator = this._asXmlGenerator(jsonGenerator);
        if (toXmlGenerator == null) {
            bl = false;
        } else {
            QName qName = this._rootNameFromConfig();
            if (qName == null) {
                qName = this._rootNameLookup.findRootName(javaType, (MapperConfig<?>)this._config);
            }
            this._initWithRootName(toXmlGenerator, qName);
            bl = TypeUtil.isIndexedType(javaType);
            if (bl) {
                this._startRootArray(toXmlGenerator, qName);
            }
        }
        if (jsonSerializer == null) {
            jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, (SerializerProvider)this);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            throw new JsonMappingException(string, (Throwable)exception);
        }
        if (bl) {
            jsonGenerator.writeEndObject();
        }
    }

    protected void _serializeXmlNull(JsonGenerator jsonGenerator) throws IOException, JsonProcessingException {
        if (jsonGenerator instanceof ToXmlGenerator) {
            this._initWithRootName((ToXmlGenerator)jsonGenerator, ROOT_NAME_FOR_NULL);
        }
        super.serializeValue(jsonGenerator, null);
    }

    protected void _startRootArray(ToXmlGenerator toXmlGenerator, QName qName) throws IOException, JsonProcessingException {
        toXmlGenerator.writeStartObject();
        toXmlGenerator.writeFieldName("item");
    }

    protected void _initWithRootName(ToXmlGenerator toXmlGenerator, QName qName) throws IOException, JsonProcessingException {
        if (!toXmlGenerator.setNextNameIfMissing(qName) && toXmlGenerator.getOutputContext().inRoot()) {
            toXmlGenerator.setNextName(qName);
        }
        toXmlGenerator.initGenerator();
        String string = qName.getNamespaceURI();
        if (string != null && string.length() > 0) {
            try {
                toXmlGenerator.getStaxWriter().setDefaultNamespace(string);
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwXmlAsIOException(xMLStreamException);
            }
        }
    }

    protected QName _rootNameFromConfig() {
        String string = this._config.getRootName();
        return string == null ? null : new QName(string);
    }

    protected ToXmlGenerator _asXmlGenerator(JsonGenerator jsonGenerator) throws JsonMappingException {
        if (!(jsonGenerator instanceof ToXmlGenerator)) {
            if (!(jsonGenerator instanceof TokenBuffer)) {
                throw new JsonMappingException("XmlMapper does not with generators of type other than ToXmlGenerator; got: " + jsonGenerator.getClass().getName());
            }
            return null;
        }
        return (ToXmlGenerator)jsonGenerator;
    }
}

