/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;

public class XmlTextDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 1L;
    protected final int _xmlTextPropertyIndex;
    protected final SettableBeanProperty _xmlTextProperty;
    protected final ValueInstantiator _valueInstantiator;

    public XmlTextDeserializer(BeanDeserializerBase beanDeserializerBase, SettableBeanProperty settableBeanProperty) {
        super((JsonDeserializer)beanDeserializerBase);
        this._xmlTextProperty = settableBeanProperty;
        this._xmlTextPropertyIndex = settableBeanProperty.getPropertyIndex();
        this._valueInstantiator = beanDeserializerBase.getValueInstantiator();
    }

    public XmlTextDeserializer(BeanDeserializerBase beanDeserializerBase, int n) {
        super((JsonDeserializer)beanDeserializerBase);
        this._xmlTextPropertyIndex = n;
        this._valueInstantiator = beanDeserializerBase.getValueInstantiator();
        this._xmlTextProperty = beanDeserializerBase.findProperty(n);
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> jsonDeserializer) {
        throw new IllegalStateException("Internal error: should never get called");
    }

    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        return new XmlTextDeserializer(this._verifyDeserType(this._delegatee), this._xmlTextPropertyIndex);
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
            this._xmlTextProperty.deserializeAndSet(jsonParser, deserializationContext, object);
            return object;
        }
        return this._delegatee.deserialize(jsonParser, deserializationContext);
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            this._xmlTextProperty.deserializeAndSet(jsonParser, deserializationContext, object);
            return object;
        }
        return this._delegatee.deserialize(jsonParser, deserializationContext, object);
    }

    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return this._delegatee.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
    }

    protected BeanDeserializerBase _verifyDeserType(JsonDeserializer<?> jsonDeserializer) {
        if (!(jsonDeserializer instanceof BeanDeserializerBase)) {
            throw new IllegalArgumentException("Can not change delegate to be of type " + jsonDeserializer.getClass().getName());
        }
        return (BeanDeserializerBase)jsonDeserializer;
    }
}

