/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WrapperHandlingDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 1L;
    protected final Set<String> _namesToWrap;

    public WrapperHandlingDeserializer(BeanDeserializerBase beanDeserializerBase) {
        this(beanDeserializerBase, null);
    }

    public WrapperHandlingDeserializer(BeanDeserializerBase beanDeserializerBase, Set<String> set) {
        super((JsonDeserializer)beanDeserializerBase);
        this._namesToWrap = set;
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> jsonDeserializer) {
        throw new IllegalStateException("Internal error: should never get called");
    }

    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer jsonDeserializer = deserializationContext.handleSecondaryContextualization(this._delegatee, beanProperty);
        BeanDeserializerBase beanDeserializerBase = this._verifyDeserType(jsonDeserializer);
        Iterator iterator = beanDeserializerBase.properties();
        HashSet<String> hashSet = null;
        while (iterator.hasNext()) {
            PropertyName propertyName;
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)iterator.next();
            JavaType javaType = settableBeanProperty.getType();
            if (!TypeUtil.isIndexedType(javaType) || (propertyName = settableBeanProperty.getWrapperName()) != null && propertyName != PropertyName.NO_NAME) continue;
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(settableBeanProperty.getName());
        }
        if (hashSet == null) {
            return beanDeserializerBase;
        }
        return new WrapperHandlingDeserializer(beanDeserializerBase, hashSet);
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        this._configureParser(jsonParser);
        return this._delegatee.deserialize(jsonParser, deserializationContext);
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        this._configureParser(jsonParser);
        return this._delegatee.deserialize(jsonParser, deserializationContext, object);
    }

    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        this._configureParser(jsonParser);
        return this._delegatee.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
    }

    protected final void _configureParser(JsonParser jsonParser) throws IOException, JsonProcessingException {
        if (jsonParser instanceof FromXmlParser) {
            ((FromXmlParser)jsonParser).addVirtualWrapping(this._namesToWrap);
        }
    }

    protected BeanDeserializerBase _verifyDeserType(JsonDeserializer<?> jsonDeserializer) {
        if (!(jsonDeserializer instanceof BeanDeserializerBase)) {
            throw new IllegalArgumentException("Can not change delegate to be of type " + jsonDeserializer.getClass().getName());
        }
        return (BeanDeserializerBase)jsonDeserializer;
    }
}

