/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.dataformat.xml.deser.XmlReadContext;
import com.fasterxml.jackson.dataformat.xml.deser.XmlTokenStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;

public class FromXmlParser
extends ParserMinimalBase {
    public static final String DEFAULT_UNNAMED_TEXT_PROPERTY = "";
    protected String _cfgNameForTextElement = "";
    protected int _xmlFeatures;
    protected ObjectCodec _objectCodec;
    protected boolean _closed;
    protected final IOContext _ioContext;
    protected XmlReadContext _parsingContext;
    protected final XmlTokenStream _xmlTokens;
    protected boolean _mayBeLeaf;
    protected JsonToken _nextToken;
    protected String _currText;
    protected Set<String> _namesToWrap;
    protected ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;

    public FromXmlParser(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, XMLStreamReader xMLStreamReader) {
        super(n);
        this._xmlFeatures = n2;
        this._ioContext = iOContext;
        this._objectCodec = objectCodec;
        this._parsingContext = XmlReadContext.createRootContext(-1, -1);
        this._nextToken = JsonToken.START_OBJECT;
        this._xmlTokens = new XmlTokenStream(xMLStreamReader, iOContext.getSourceReference());
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public void setXMLTextElementName(String string) {
        this._cfgNameForTextElement = string;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    public FromXmlParser enable(Feature feature) {
        this._xmlFeatures |= feature.getMask();
        return this;
    }

    public FromXmlParser disable(Feature feature) {
        this._xmlFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._xmlFeatures & feature.getMask()) != 0;
    }

    public FromXmlParser configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public XMLStreamReader getStaxReader() {
        return this._xmlTokens.getXmlReader();
    }

    public void addVirtualWrapping(Set<String> set) {
        String string = this._xmlTokens.getLocalName();
        if (string != null && set.contains(string)) {
            this._xmlTokens.repeatStartElement();
        }
        this._namesToWrap = set;
        this._parsingContext.setNamesToWrap(set);
    }

    public String getCurrentName() throws IOException, JsonParseException {
        String string;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            XmlReadContext xmlReadContext = this._parsingContext.getParent();
            string = xmlReadContext.getCurrentName();
        } else {
            string = this._parsingContext.getCurrentName();
        }
        if (string == null) {
            throw new IllegalStateException("Missing name, in state: " + this._currToken);
        }
        return string;
    }

    public void overrideCurrentName(String string) {
        XmlReadContext xmlReadContext = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            xmlReadContext = xmlReadContext.getParent();
        }
        xmlReadContext.setCurrentName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            try {
                if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                    this._xmlTokens.closeCompletely();
                } else {
                    this._xmlTokens.close();
                }
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public XmlReadContext getParsingContext() {
        return this._parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return this._xmlTokens.getTokenLocation();
    }

    public JsonLocation getCurrentLocation() {
        return this._xmlTokens.getCurrentLocation();
    }

    public boolean isExpectedStartArrayToken() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.START_OBJECT) {
            this._currToken = JsonToken.START_ARRAY;
            this._parsingContext.convertToArray();
            this._nextToken = null;
            this._xmlTokens.skipAttributes();
            return true;
        }
        return jsonToken == JsonToken.START_ARRAY;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        this._binaryValue = null;
        if (this._nextToken != null) {
            JsonToken jsonToken;
            this._currToken = jsonToken = this._nextToken;
            this._nextToken = null;
            switch (jsonToken) {
                case START_OBJECT: {
                    this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                    break;
                }
                case START_ARRAY: {
                    this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    this._parsingContext = this._parsingContext.getParent();
                    this._namesToWrap = this._parsingContext.getNamesToWrap();
                    break;
                }
                case FIELD_NAME: {
                    this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                    break;
                }
            }
            return jsonToken;
        }
        int n = this._xmlTokens.next();
        while (n == 1) {
            if (this._mayBeLeaf) {
                this._nextToken = JsonToken.FIELD_NAME;
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            if (this._parsingContext.inArray()) {
                n = this._xmlTokens.next();
                this._mayBeLeaf = true;
                continue;
            }
            String string = this._xmlTokens.getLocalName();
            this._parsingContext.setCurrentName(string);
            if (this._namesToWrap != null && this._namesToWrap.contains(string)) {
                this._xmlTokens.repeatStartElement();
            }
            this._mayBeLeaf = true;
            this._currToken = JsonToken.FIELD_NAME;
            return this._currToken;
        }
        switch (n) {
            case 2: {
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._currToken = JsonToken.VALUE_NULL;
                    return this._currToken;
                }
                this._currToken = this._parsingContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
                this._parsingContext = this._parsingContext.getParent();
                this._namesToWrap = this._parsingContext.getNamesToWrap();
                return this._currToken;
            }
            case 3: {
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._nextToken = JsonToken.FIELD_NAME;
                    this._currText = this._xmlTokens.getText();
                    this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                    this._currToken = JsonToken.START_OBJECT;
                    return this._currToken;
                }
                this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                this._currToken = JsonToken.FIELD_NAME;
                return this._currToken;
            }
            case 4: {
                this._currText = this._xmlTokens.getText();
                this._currToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            case 5: {
                this._currText = this._xmlTokens.getText();
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._xmlTokens.skipEndElement();
                    if (this._parsingContext.inArray() && this._isEmpty(this._currText)) {
                        this._currToken = JsonToken.END_ARRAY;
                        this._parsingContext = this._parsingContext.getParent();
                        this._namesToWrap = this._parsingContext.getNamesToWrap();
                        return this._currToken;
                    }
                    this._currToken = JsonToken.VALUE_STRING;
                    return this._currToken;
                }
                this._parsingContext.setCurrentName(this._cfgNameForTextElement);
                this._nextToken = JsonToken.VALUE_STRING;
                this._currToken = JsonToken.FIELD_NAME;
                return this._currToken;
            }
            case 6: {
                this._currToken = null;
                return null;
            }
        }
        this._throwInternal();
        return null;
    }

    public String getText() throws IOException, JsonParseException {
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this.getCurrentName();
            }
            case VALUE_STRING: {
                return this._currText;
            }
        }
        return this._currToken.asString();
    }

    public final String getValueAsString() throws IOException, JsonParseException {
        return this.getValueAsString(null);
    }

    public String getValueAsString(String string) throws IOException, JsonParseException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken) {
            case FIELD_NAME: {
                return this.getCurrentName();
            }
            case VALUE_STRING: {
                return this._currText;
            }
            case START_OBJECT: {
                String string2 = this._xmlTokens.convertToString();
                if (string2 != null) {
                    this._parsingContext = this._parsingContext.getParent();
                    this._namesToWrap = this._parsingContext.getNamesToWrap();
                    this._currToken = JsonToken.VALUE_STRING;
                    this._nextToken = null;
                    this._xmlTokens.skipEndElement();
                    this._currText = string2;
                    return this._currText;
                }
                return null;
            }
        }
        if (this._currToken.isScalarValue()) {
            return this._currToken.asString();
        }
        return string;
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        String string = this.getText();
        return string == null ? null : string.toCharArray();
    }

    public int getTextLength() throws IOException, JsonParseException {
        String string = this.getText();
        return string == null ? 0 : string.length();
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        return null;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + this._currToken + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._binaryValue == null) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
        }
        return this._binaryValue;
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) throws IOException, JsonParseException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        String string = this.getText();
        this._decodeBase64(string, byteArrayBuilder, base64Variant);
        return byteArrayBuilder.toByteArray();
    }

    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        return null;
    }

    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        return null;
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        return 0.0;
    }

    public float getFloatValue() throws IOException, JsonParseException {
        return 0.0f;
    }

    public int getIntValue() throws IOException, JsonParseException {
        return 0;
    }

    public long getLongValue() throws IOException, JsonParseException {
        return 0L;
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        return null;
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        return null;
    }

    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            this._reportInvalidEOF(": expected close marker for " + this._parsingContext.getTypeDesc() + " (from " + this._parsingContext.getStartLocation(this._ioContext.getSourceReference()) + ")");
        }
    }

    protected void _releaseBuffers() throws IOException {
    }

    protected ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected boolean _isEmpty(String string) {
        int n;
        int n2 = n = string == null ? 0 : string.length();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static enum Feature {
        DUMMY_PLACEHOLDER(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.getMask();
            }
            return n;
        }

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

