/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import java.util.Collection;

public class XmlTypeResolverBuilder
extends StdTypeResolverBuilder {
    public StdTypeResolverBuilder init(JsonTypeInfo.Id id, TypeIdResolver typeIdResolver) {
        super.init(id, typeIdResolver);
        if (this._typeProperty != null) {
            this._typeProperty = StaxUtil.sanitizeXmlTypeName(this._typeProperty);
        }
        return this;
    }

    public StdTypeResolverBuilder typeProperty(String string) {
        if (string == null || string.length() == 0) {
            string = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = StaxUtil.sanitizeXmlTypeName(string);
        return this;
    }

    protected TypeIdResolver idResolver(MapperConfig<?> mapperConfig, JavaType javaType, Collection<NamedType> collection, boolean bl, boolean bl2) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        switch (this._idType) {
            case CLASS: {
                return new XmlClassNameIdResolver(javaType, mapperConfig.getTypeFactory());
            }
            case MINIMAL_CLASS: {
                return new XmlMinimalClassNameIdResolver(javaType, mapperConfig.getTypeFactory());
            }
        }
        return super.idResolver(mapperConfig, javaType, collection, bl, bl2);
    }

    protected static String encodeXmlClassName(String string) {
        int n = string.lastIndexOf(36);
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            do {
                stringBuilder.replace(n, n + 1, "..");
            } while ((n = string.lastIndexOf(36, n - 1)) >= 0);
            string = stringBuilder.toString();
        }
        return string;
    }

    protected static String decodeXmlClassName(String string) {
        int n = string.lastIndexOf("..");
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            do {
                stringBuilder.replace(n, n + 2, "$");
            } while ((n = string.lastIndexOf("..", n - 1)) >= 0);
            string = stringBuilder.toString();
        }
        return string;
    }

    protected static class XmlMinimalClassNameIdResolver
    extends MinimalClassNameIdResolver {
        public XmlMinimalClassNameIdResolver(JavaType javaType, TypeFactory typeFactory) {
            super(javaType, typeFactory);
        }

        public String idFromValue(Object object) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(object));
        }

        public JavaType typeFromId(String string) {
            return super.typeFromId(XmlTypeResolverBuilder.decodeXmlClassName(string));
        }

        public JavaType typeFromId(DatabindContext databindContext, String string) {
            return super.typeFromId(databindContext, XmlTypeResolverBuilder.decodeXmlClassName(string));
        }
    }

    protected static class XmlClassNameIdResolver
    extends ClassNameIdResolver {
        public XmlClassNameIdResolver(JavaType javaType, TypeFactory typeFactory) {
            super(javaType, typeFactory);
        }

        public String idFromValue(Object object) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(object));
        }

        public JavaType typeFromId(String string) {
            return super.typeFromId(XmlTypeResolverBuilder.decodeXmlClassName(string));
        }

        public JavaType typeFromId(DatabindContext databindContext, String string) {
            return super.typeFromId(databindContext, XmlTypeResolverBuilder.decodeXmlClassName(string));
        }
    }
}

