/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.xml.PackageVersion;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.codehaus.stax2.io.Stax2ByteArraySource;

public class XmlFactory
extends JsonFactory {
    private static final long serialVersionUID = -2793875812715996133L;
    public static final String FORMAT_NAME_XML = "XML";
    static final int DEFAULT_XML_PARSER_FEATURE_FLAGS = FromXmlParser.Feature.collectDefaults();
    static final int DEFAULT_XML_GENERATOR_FEATURE_FLAGS = ToXmlGenerator.Feature.collectDefaults();
    protected int _xmlParserFeatures;
    protected int _xmlGeneratorFeatures;
    protected transient XMLInputFactory _xmlInputFactory;
    protected transient XMLOutputFactory _xmlOutputFactory;
    protected String _cfgNameForTextElement;
    protected transient String _jdkXmlInFactory;
    protected transient String _jdkXmlOutFactory;
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;
    private static final byte BYTE_x = 120;
    private static final byte BYTE_m = 109;
    private static final byte BYTE_l = 108;
    private static final byte BYTE_D = 68;
    private static final byte BYTE_LT = 60;
    private static final byte BYTE_QMARK = 63;
    private static final byte BYTE_EXCL = 33;
    private static final byte BYTE_HYPHEN = 45;

    public XmlFactory() {
        this(null);
    }

    public XmlFactory(ObjectCodec objectCodec) {
        this(objectCodec, null, null);
    }

    public XmlFactory(XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory) {
        this(null, xMLInputFactory, xMLOutputFactory);
    }

    public XmlFactory(ObjectCodec objectCodec, XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory) {
        this(objectCodec, DEFAULT_XML_PARSER_FEATURE_FLAGS, DEFAULT_XML_GENERATOR_FEATURE_FLAGS, xMLInputFactory, xMLOutputFactory, null);
    }

    protected XmlFactory(ObjectCodec objectCodec, int n, int n2, XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory, String string) {
        super(objectCodec);
        this._xmlParserFeatures = n;
        this._xmlGeneratorFeatures = n2;
        this._cfgNameForTextElement = string;
        if (xMLInputFactory == null) {
            xMLInputFactory = XMLInputFactory.newInstance();
        }
        if (xMLOutputFactory == null) {
            xMLOutputFactory = XMLOutputFactory.newInstance();
        }
        this._initFactories(xMLInputFactory, xMLOutputFactory);
        this._xmlInputFactory = xMLInputFactory;
        this._xmlOutputFactory = xMLOutputFactory;
    }

    protected XmlFactory(XmlFactory xmlFactory, ObjectCodec objectCodec) {
        super((JsonFactory)xmlFactory, objectCodec);
        this._xmlParserFeatures = xmlFactory._xmlParserFeatures;
        this._xmlGeneratorFeatures = xmlFactory._xmlGeneratorFeatures;
        this._cfgNameForTextElement = xmlFactory._cfgNameForTextElement;
        this._xmlInputFactory = xmlFactory._xmlInputFactory;
        this._xmlOutputFactory = xmlFactory._xmlOutputFactory;
    }

    protected void _initFactories(XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory) {
        xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
    }

    public XmlFactory copy() {
        this._checkInvalidCopy(XmlFactory.class);
        return new XmlFactory(this, null);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected Object readResolve() {
        if (this._jdkXmlInFactory == null) {
            throw new IllegalStateException("No XMLInputFactory class name read during JDK deserialization");
        }
        if (this._jdkXmlOutFactory == null) {
            throw new IllegalStateException("No XMLOutputFactory class name read during JDK deserialization");
        }
        try {
            XMLInputFactory xMLInputFactory = (XMLInputFactory)Class.forName(this._jdkXmlInFactory).newInstance();
            XMLOutputFactory xMLOutputFactory = (XMLOutputFactory)Class.forName(this._jdkXmlOutFactory).newInstance();
            return new XmlFactory(this._objectCodec, this._xmlParserFeatures, this._xmlGeneratorFeatures, xMLInputFactory, xMLOutputFactory, this._cfgNameForTextElement);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._jdkXmlInFactory = objectInputStream.readUTF();
        this._jdkXmlOutFactory = objectInputStream.readUTF();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this._xmlInputFactory.getClass().getName());
        objectOutputStream.writeUTF(this._xmlOutputFactory.getClass().getName());
    }

    public void setXMLTextElementName(String string) {
        this._cfgNameForTextElement = string;
    }

    public String getXMLTextElementName() {
        return this._cfgNameForTextElement;
    }

    public final XmlFactory configure(FromXmlParser.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public XmlFactory enable(FromXmlParser.Feature feature) {
        this._xmlParserFeatures |= feature.getMask();
        return this;
    }

    public XmlFactory disable(FromXmlParser.Feature feature) {
        this._xmlParserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(FromXmlParser.Feature feature) {
        return (this._xmlParserFeatures & feature.getMask()) != 0;
    }

    public final XmlFactory configure(ToXmlGenerator.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public XmlFactory enable(ToXmlGenerator.Feature feature) {
        this._xmlGeneratorFeatures |= feature.getMask();
        return this;
    }

    public XmlFactory disable(ToXmlGenerator.Feature feature) {
        this._xmlGeneratorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(ToXmlGenerator.Feature feature) {
        return (this._xmlGeneratorFeatures & feature.getMask()) != 0;
    }

    public void setXMLInputFactory(XMLInputFactory xMLInputFactory) {
        this._xmlInputFactory = xMLInputFactory;
    }

    public void setXMLOutputFactory(XMLOutputFactory xMLOutputFactory) {
        this._xmlOutputFactory = xMLOutputFactory;
    }

    public String getFormatName() {
        return FORMAT_NAME_XML;
    }

    public MatchStrength hasFormat(InputAccessor inputAccessor) throws IOException {
        return XmlFactory.hasXMLFormat(inputAccessor);
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    public ToXmlGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(outputStream, JsonEncoding.UTF8);
    }

    public ToXmlGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return new ToXmlGenerator(this._createContext(outputStream, false), this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(outputStream));
    }

    public ToXmlGenerator createGenerator(Writer writer) throws IOException {
        return new ToXmlGenerator(this._createContext(writer, false), this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(writer));
    }

    public ToXmlGenerator createGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOContext iOContext = this._createContext(fileOutputStream, true);
        iOContext.setEncoding(jsonEncoding);
        return new ToXmlGenerator(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(fileOutputStream));
    }

    @Deprecated
    public ToXmlGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return this.createGenerator(outputStream, jsonEncoding);
    }

    @Deprecated
    public ToXmlGenerator createJsonGenerator(Writer writer) throws IOException {
        return this.createGenerator(writer);
    }

    @Deprecated
    public ToXmlGenerator createJsonGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        return this.createGenerator(file, jsonEncoding);
    }

    protected FromXmlParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        XMLStreamReader xMLStreamReader;
        try {
            xMLStreamReader = this._xmlInputFactory.createXMLStreamReader(inputStream);
            xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            return (FromXmlParser)((Object)StaxUtil.throwXmlAsIOException(xMLStreamException));
        }
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, xMLStreamReader);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    protected FromXmlParser _createParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        XMLStreamReader xMLStreamReader;
        try {
            xMLStreamReader = this._xmlInputFactory.createXMLStreamReader(reader);
            xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            return (FromXmlParser)((Object)StaxUtil.throwXmlAsIOException(xMLStreamException));
        }
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, xMLStreamReader);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    protected FromXmlParser _createParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        XMLStreamReader xMLStreamReader;
        try {
            xMLStreamReader = this._xmlInputFactory.createXMLStreamReader((Source)new Stax2ByteArraySource(byArray, n, n2));
            xMLStreamReader = this._initializeXmlReader(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            return (FromXmlParser)((Object)StaxUtil.throwXmlAsIOException(xMLStreamException));
        }
        FromXmlParser fromXmlParser = new FromXmlParser(iOContext, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, xMLStreamReader);
        if (this._cfgNameForTextElement != null) {
            fromXmlParser.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return fromXmlParser;
    }

    @Deprecated
    protected FromXmlParser _createJsonParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        return this._createParser(inputStream, iOContext);
    }

    @Deprecated
    protected FromXmlParser _createJsonParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        return this._createParser(reader, iOContext);
    }

    @Deprecated
    protected FromXmlParser _createJsonParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        return this._createParser(byArray, n, n2, iOContext);
    }

    protected XMLStreamWriter _createXmlWriter(OutputStream outputStream) throws IOException {
        try {
            return this._initializeXmlWriter(this._xmlOutputFactory.createXMLStreamWriter(outputStream, "UTF-8"));
        }
        catch (XMLStreamException xMLStreamException) {
            return (XMLStreamWriter)StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    protected XMLStreamWriter _createXmlWriter(Writer writer) throws IOException {
        try {
            return this._initializeXmlWriter(this._xmlOutputFactory.createXMLStreamWriter(writer));
        }
        catch (XMLStreamException xMLStreamException) {
            return (XMLStreamWriter)StaxUtil.throwXmlAsIOException(xMLStreamException);
        }
    }

    protected final XMLStreamWriter _initializeXmlWriter(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        xMLStreamWriter.setDefaultNamespace("");
        return xMLStreamWriter;
    }

    protected final XMLStreamReader _initializeXmlReader(XMLStreamReader xMLStreamReader) throws IOException, XMLStreamException {
        while (xMLStreamReader.next() != 1) {
        }
        return xMLStreamReader;
    }

    public static MatchStrength hasXMLFormat(InputAccessor inputAccessor) throws IOException {
        boolean bl;
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by = inputAccessor.nextByte();
        if (by == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by = inputAccessor.nextByte();
        }
        boolean bl2 = bl = by == 60;
        if (!bl) {
            int n = XmlFactory.skipSpace(inputAccessor, by);
            if (n < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            by = (byte)n;
            if (by != 60) {
                return MatchStrength.NO_MATCH;
            }
        }
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        by = inputAccessor.nextByte();
        if (by == 63) {
            by = inputAccessor.nextByte();
            if (by == 120) {
                if (bl && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 109 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 108) {
                    return MatchStrength.FULL_MATCH;
                }
                return MatchStrength.SOLID_MATCH;
            }
            if (XmlFactory.validXmlNameStartChar(inputAccessor, by)) {
                return MatchStrength.SOLID_MATCH;
            }
        } else if (by == 33) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by = inputAccessor.nextByte();
            if (by == 45) {
                if (!inputAccessor.hasMoreBytes()) {
                    return MatchStrength.INCONCLUSIVE;
                }
                if (inputAccessor.nextByte() == 45) {
                    return MatchStrength.SOLID_MATCH;
                }
            } else if (by == 68) {
                return XmlFactory.tryMatch(inputAccessor, "OCTYPE", MatchStrength.SOLID_MATCH);
            }
        } else if (XmlFactory.validXmlNameStartChar(inputAccessor, by)) {
            return MatchStrength.SOLID_MATCH;
        }
        return MatchStrength.NO_MATCH;
    }

    private static final boolean validXmlNameStartChar(InputAccessor inputAccessor, byte by) throws IOException {
        int n = by & 0xFF;
        return n >= 65;
    }

    private static final MatchStrength tryMatch(InputAccessor inputAccessor, String string, MatchStrength matchStrength) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() == string.charAt(i)) continue;
            return MatchStrength.NO_MATCH;
        }
        return matchStrength;
    }

    private static final int skipSpace(InputAccessor inputAccessor, byte by) throws IOException {
        int n;
        while ((n = by & 0xFF) == 32 || n == 13 || n == 10 || n == 9) {
            if (!inputAccessor.hasMoreBytes()) {
                return -1;
            }
            by = inputAccessor.nextByte();
            n = by & 0xFF;
        }
        return n;
    }
}

