/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.dataformat.xml.XmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.XmlTypeResolverBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;

public class JacksonXmlAnnotationIntrospector
extends JacksonAnnotationIntrospector
implements XmlAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    public static final boolean DEFAULT_USE_WRAPPER = true;
    protected final boolean _cfgDefaultUseWrapper;

    public JacksonXmlAnnotationIntrospector() {
        this(true);
    }

    public JacksonXmlAnnotationIntrospector(boolean bl) {
        this._cfgDefaultUseWrapper = bl;
    }

    public PropertyName findWrapperName(Annotated annotated) {
        JacksonXmlElementWrapper jacksonXmlElementWrapper = (JacksonXmlElementWrapper)annotated.getAnnotation(JacksonXmlElementWrapper.class);
        if (jacksonXmlElementWrapper != null) {
            if (!jacksonXmlElementWrapper.useWrapping()) {
                return PropertyName.NO_NAME;
            }
            String string = jacksonXmlElementWrapper.localName();
            if (string == null || string.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return PropertyName.construct((String)jacksonXmlElementWrapper.localName(), (String)jacksonXmlElementWrapper.namespace());
        }
        if (this._cfgDefaultUseWrapper) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    public PropertyName findRootName(AnnotatedClass annotatedClass) {
        JacksonXmlRootElement jacksonXmlRootElement = (JacksonXmlRootElement)annotatedClass.getAnnotation(JacksonXmlRootElement.class);
        if (jacksonXmlRootElement != null) {
            String string = jacksonXmlRootElement.localName();
            String string2 = jacksonXmlRootElement.namespace();
            if (string.length() == 0 && string2.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(string, string2);
        }
        return super.findRootName(annotatedClass);
    }

    @Override
    public String findNamespace(Annotated annotated) {
        JacksonXmlProperty jacksonXmlProperty = (JacksonXmlProperty)annotated.getAnnotation(JacksonXmlProperty.class);
        if (jacksonXmlProperty != null) {
            return jacksonXmlProperty.namespace();
        }
        return null;
    }

    @Override
    public Boolean isOutputAsAttribute(Annotated annotated) {
        JacksonXmlProperty jacksonXmlProperty = (JacksonXmlProperty)annotated.getAnnotation(JacksonXmlProperty.class);
        if (jacksonXmlProperty != null) {
            return jacksonXmlProperty.isAttribute() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Boolean isOutputAsText(Annotated annotated) {
        JacksonXmlText jacksonXmlText = (JacksonXmlText)annotated.getAnnotation(JacksonXmlText.class);
        if (jacksonXmlText != null) {
            return jacksonXmlText.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public PropertyName findNameForSerialization(Annotated annotated) {
        PropertyName propertyName = this._findXmlName(annotated);
        if (propertyName == null && (propertyName = super.findNameForSerialization(annotated)) == null && annotated.hasAnnotation(JacksonXmlText.class)) {
            return PropertyName.USE_DEFAULT;
        }
        return propertyName;
    }

    @Deprecated
    public String findSerializationName(AnnotatedField annotatedField) {
        PropertyName propertyName = this._findXmlName((Annotated)annotatedField);
        if (propertyName != null) {
            return propertyName.getSimpleName();
        }
        String string = super.findSerializationName(annotatedField);
        if (string == null && annotatedField.hasAnnotation(JacksonXmlText.class)) {
            return "";
        }
        return string;
    }

    @Deprecated
    public String findSerializationName(AnnotatedMethod annotatedMethod) {
        PropertyName propertyName = this._findXmlName((Annotated)annotatedMethod);
        if (propertyName != null) {
            return propertyName.getSimpleName();
        }
        String string = super.findSerializationName(annotatedMethod);
        if (string == null && annotatedMethod.hasAnnotation(JacksonXmlText.class)) {
            return "";
        }
        return string;
    }

    public PropertyName findNameForDeserialization(Annotated annotated) {
        PropertyName propertyName = this._findXmlName(annotated);
        if (propertyName == null && (propertyName = super.findNameForDeserialization(annotated)) == null && annotated.hasAnnotation(JacksonXmlText.class)) {
            return PropertyName.USE_DEFAULT;
        }
        return propertyName;
    }

    @Deprecated
    public String findDeserializationName(AnnotatedField annotatedField) {
        PropertyName propertyName = this._findXmlName((Annotated)annotatedField);
        if (propertyName != null) {
            return propertyName.getSimpleName();
        }
        String string = super.findDeserializationName(annotatedField);
        if (string == null && annotatedField.hasAnnotation(JacksonXmlText.class)) {
            return "";
        }
        return string;
    }

    @Deprecated
    public String findDeserializationName(AnnotatedMethod annotatedMethod) {
        PropertyName propertyName = this._findXmlName((Annotated)annotatedMethod);
        if (propertyName != null) {
            return propertyName.getSimpleName();
        }
        String string = super.findDeserializationName(annotatedMethod);
        if (string == null && annotatedMethod.hasAnnotation(JacksonXmlText.class)) {
            return "";
        }
        return string;
    }

    @Deprecated
    public String findDeserializationName(AnnotatedParameter annotatedParameter) {
        String string;
        PropertyName propertyName = this._findXmlName((Annotated)annotatedParameter);
        if (propertyName != null && (string = propertyName.getSimpleName()) != null && string.length() > 0) {
            return string;
        }
        string = super.findDeserializationName(annotatedParameter);
        if (string == null && annotatedParameter.hasAnnotation(JacksonXmlText.class)) {
            return "";
        }
        return super.findDeserializationName(annotatedParameter);
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new XmlTypeResolverBuilder();
    }

    protected PropertyName _findXmlName(Annotated annotated) {
        JacksonXmlProperty jacksonXmlProperty = (JacksonXmlProperty)annotated.getAnnotation(JacksonXmlProperty.class);
        if (jacksonXmlProperty != null) {
            return PropertyName.construct((String)jacksonXmlProperty.localName(), (String)jacksonXmlProperty.namespace());
        }
        return null;
    }
}

