/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.runtime;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.runtime.ArchivaRuntimeConfigurationAdmin;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ArchivaRuntimeConfiguration;
import org.apache.archiva.configuration.CacheConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.FileLockConfiguration;
import org.apache.archiva.configuration.IndeterminateConfigurationException;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.components.registry.RegistryException;
import org.springframework.stereotype.Service;

@Service(value="archivaRuntimeConfigurationAdmin#default")
public class DefaultArchivaRuntimeConfigurationAdmin
extends AbstractRepositoryAdmin
implements ArchivaRuntimeConfigurationAdmin {
    @Inject
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    @Named(value="cache#url-failures-cache")
    private Cache urlFailureCache;

    @PostConstruct
    public void initialize() throws RepositoryAdminException {
        org.apache.archiva.admin.model.beans.ArchivaRuntimeConfiguration archivaRuntimeConfiguration = this.getArchivaRuntimeConfiguration();
        boolean save = false;
        if (archivaRuntimeConfiguration.getFileLockConfiguration() == null) {
            archivaRuntimeConfiguration.setFileLockConfiguration(new org.apache.archiva.admin.model.beans.FileLockConfiguration());
        }
        if (archivaRuntimeConfiguration.getUrlFailureCacheConfiguration() == null) {
            archivaRuntimeConfiguration.setUrlFailureCacheConfiguration(new org.apache.archiva.admin.model.beans.CacheConfiguration());
        }
        if (archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().getTimeToIdleSeconds() < 0) {
            archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().setTimeToIdleSeconds(this.urlFailureCache.getTimeToIdleSeconds());
            save = true;
        }
        this.urlFailureCache.setTimeToIdleSeconds(archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().getTimeToIdleSeconds());
        if (archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().getTimeToLiveSeconds() < 0) {
            archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().setTimeToLiveSeconds(this.urlFailureCache.getTimeToLiveSeconds());
            save = true;
        }
        this.urlFailureCache.setTimeToLiveSeconds(archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().getTimeToLiveSeconds());
        if (archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().getMaxElementsInMemory() < 0) {
            archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().setMaxElementsInMemory(this.urlFailureCache.getMaxElementsInMemory());
            save = true;
        }
        this.urlFailureCache.setMaxElementsInMemory(archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().getMaxElementsInMemory());
        if (archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().getMaxElementsOnDisk() < 0) {
            archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().setMaxElementsOnDisk(this.urlFailureCache.getMaxElementsOnDisk());
            save = true;
        }
        this.urlFailureCache.setMaxElementsOnDisk(archivaRuntimeConfiguration.getUrlFailureCacheConfiguration().getMaxElementsOnDisk());
        if (save) {
            this.updateArchivaRuntimeConfiguration(archivaRuntimeConfiguration);
        }
    }

    public org.apache.archiva.admin.model.beans.ArchivaRuntimeConfiguration getArchivaRuntimeConfiguration() throws RepositoryAdminException {
        return this.build(this.archivaConfiguration.getConfiguration().getArchivaRuntimeConfiguration());
    }

    public void updateArchivaRuntimeConfiguration(org.apache.archiva.admin.model.beans.ArchivaRuntimeConfiguration archivaRuntimeConfiguration) throws RepositoryAdminException {
        Configuration configuration = this.archivaConfiguration.getConfiguration();
        configuration.setArchivaRuntimeConfiguration(this.build(archivaRuntimeConfiguration));
        try {
            this.archivaConfiguration.save(configuration);
        }
        catch (RegistryException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
        catch (IndeterminateConfigurationException e) {
            throw new RepositoryAdminException(e.getMessage(), (Throwable)e);
        }
    }

    protected org.apache.archiva.admin.model.beans.ArchivaRuntimeConfiguration build(ArchivaRuntimeConfiguration archivaRuntimeConfiguration) {
        if (archivaRuntimeConfiguration == null) {
            return new org.apache.archiva.admin.model.beans.ArchivaRuntimeConfiguration();
        }
        org.apache.archiva.admin.model.beans.ArchivaRuntimeConfiguration res = (org.apache.archiva.admin.model.beans.ArchivaRuntimeConfiguration)this.getModelMapper().map((Object)archivaRuntimeConfiguration, org.apache.archiva.admin.model.beans.ArchivaRuntimeConfiguration.class);
        if (archivaRuntimeConfiguration.getUrlFailureCacheConfiguration() != null) {
            res.setUrlFailureCacheConfiguration((org.apache.archiva.admin.model.beans.CacheConfiguration)this.getModelMapper().map((Object)archivaRuntimeConfiguration.getUrlFailureCacheConfiguration(), org.apache.archiva.admin.model.beans.CacheConfiguration.class));
        }
        if (archivaRuntimeConfiguration.getFileLockConfiguration() != null) {
            res.setFileLockConfiguration((org.apache.archiva.admin.model.beans.FileLockConfiguration)this.getModelMapper().map((Object)archivaRuntimeConfiguration.getFileLockConfiguration(), org.apache.archiva.admin.model.beans.FileLockConfiguration.class));
        }
        return res;
    }

    protected ArchivaRuntimeConfiguration build(org.apache.archiva.admin.model.beans.ArchivaRuntimeConfiguration archivaRuntimeConfiguration) {
        if (archivaRuntimeConfiguration == null) {
            return new ArchivaRuntimeConfiguration();
        }
        ArchivaRuntimeConfiguration res = (ArchivaRuntimeConfiguration)this.getModelMapper().map((Object)archivaRuntimeConfiguration, ArchivaRuntimeConfiguration.class);
        if (archivaRuntimeConfiguration.getUrlFailureCacheConfiguration() != null) {
            res.setUrlFailureCacheConfiguration((CacheConfiguration)this.getModelMapper().map((Object)archivaRuntimeConfiguration.getUrlFailureCacheConfiguration(), CacheConfiguration.class));
        }
        if (archivaRuntimeConfiguration.getFileLockConfiguration() != null) {
            res.setFileLockConfiguration((FileLockConfiguration)this.getModelMapper().map((Object)archivaRuntimeConfiguration.getFileLockConfiguration(), FileLockConfiguration.class));
        }
        return res;
    }
}

