/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.repository.networkproxy;

import java.util.ArrayList;
import java.util.List;
import org.apache.archiva.admin.model.AuditInformation;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.NetworkProxy;
import org.apache.archiva.admin.model.networkproxy.NetworkProxyAdmin;
import org.apache.archiva.admin.repository.AbstractRepositoryAdmin;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.NetworkProxyConfiguration;
import org.apache.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="networkProxyAdmin#default")
public class DefaultNetworkProxyAdmin
extends AbstractRepositoryAdmin
implements NetworkProxyAdmin {
    public List<NetworkProxy> getNetworkProxies() throws RepositoryAdminException {
        ArrayList<NetworkProxy> networkProxies = new ArrayList<NetworkProxy>(this.getArchivaConfiguration().getConfiguration().getNetworkProxies().size());
        for (NetworkProxyConfiguration networkProxyConfiguration : this.getArchivaConfiguration().getConfiguration().getNetworkProxies()) {
            networkProxies.add(this.getNetworkProxy(networkProxyConfiguration));
        }
        return networkProxies;
    }

    public NetworkProxy getNetworkProxy(String networkProxyId) throws RepositoryAdminException {
        for (NetworkProxy networkProxy : this.getNetworkProxies()) {
            if (!StringUtils.equals((String)networkProxyId, (String)networkProxy.getId())) continue;
            return networkProxy;
        }
        return null;
    }

    public void addNetworkProxy(NetworkProxy networkProxy, AuditInformation auditInformation) throws RepositoryAdminException {
        if (networkProxy == null) {
            return;
        }
        if (this.getNetworkProxy(networkProxy.getId()) != null) {
            throw new RepositoryAdminException("cannot add NetworkProxy with id " + networkProxy.getId() + " already exist");
        }
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        configuration.addNetworkProxy(this.getNetworkProxyConfiguration(networkProxy));
        this.triggerAuditEvent(networkProxy.getId(), null, "Added Network Proxy", auditInformation);
        this.saveConfiguration(configuration);
    }

    public void updateNetworkProxy(NetworkProxy networkProxy, AuditInformation auditInformation) throws RepositoryAdminException {
        if (networkProxy == null) {
            return;
        }
        if (this.getNetworkProxy(networkProxy.getId()) == null) {
            throw new RepositoryAdminException("cannot update NetworkProxy with id " + networkProxy.getId() + " as not exist");
        }
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        NetworkProxyConfiguration networkProxyConfiguration = this.getNetworkProxyConfiguration(networkProxy);
        configuration.removeNetworkProxy(networkProxyConfiguration);
        configuration.addNetworkProxy(networkProxyConfiguration);
        this.triggerAuditEvent(networkProxy.getId(), null, "Updated Network Proxy", auditInformation);
        this.saveConfiguration(configuration);
    }

    public void deleteNetworkProxy(String networkProxyId, AuditInformation auditInformation) throws RepositoryAdminException {
        NetworkProxy networkProxy = this.getNetworkProxy(networkProxyId);
        if (networkProxy == null) {
            throw new RepositoryAdminException("cannot delete NetworkProxy with id " + networkProxyId + " as not exist");
        }
        Configuration configuration = this.getArchivaConfiguration().getConfiguration();
        NetworkProxyConfiguration networkProxyConfiguration = this.getNetworkProxyConfiguration(networkProxy);
        configuration.removeNetworkProxy(networkProxyConfiguration);
        for (RemoteRepositoryConfiguration rrc : configuration.getRemoteRepositories()) {
            if (!StringUtils.equals((String)rrc.getRemoteDownloadNetworkProxyId(), (String)networkProxyId)) continue;
            rrc.setRemoteDownloadNetworkProxyId(null);
        }
        this.triggerAuditEvent(networkProxy.getId(), null, "Deleted Network Proxy", auditInformation);
        this.saveConfiguration(configuration);
    }

    protected NetworkProxy getNetworkProxy(NetworkProxyConfiguration networkProxyConfiguration) {
        return networkProxyConfiguration == null ? null : (NetworkProxy)this.getModelMapper().map((Object)networkProxyConfiguration, NetworkProxy.class);
    }

    protected NetworkProxyConfiguration getNetworkProxyConfiguration(NetworkProxy networkProxy) {
        return networkProxy == null ? null : (NetworkProxyConfiguration)this.getModelMapper().map((Object)networkProxy, NetworkProxyConfiguration.class);
    }
}

