/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.scheduler.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.common.ArchivaException;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationEvent;
import org.apache.archiva.configuration.ConfigurationListener;
import org.apache.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.metadata.repository.stats.RepositoryStatisticsManager;
import org.apache.archiva.redback.components.scheduler.CronExpressionValidator;
import org.apache.archiva.redback.components.scheduler.Scheduler;
import org.apache.archiva.redback.components.taskqueue.Task;
import org.apache.archiva.redback.components.taskqueue.TaskQueue;
import org.apache.archiva.redback.components.taskqueue.TaskQueueException;
import org.apache.archiva.scheduler.repository.RepositoryTaskJob;
import org.apache.archiva.scheduler.repository.model.RepositoryArchivaTaskScheduler;
import org.apache.archiva.scheduler.repository.model.RepositoryTask;
import org.apache.commons.lang.time.StopWatch;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="archivaTaskScheduler#repository")
public class DefaultRepositoryArchivaTaskScheduler
implements RepositoryArchivaTaskScheduler,
ConfigurationListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private Scheduler scheduler;
    @Inject
    private CronExpressionValidator cronValidator;
    @Inject
    @Named(value="taskQueue#repository-scanning")
    private TaskQueue repositoryScanningQueue;
    @Inject
    private ArchivaConfiguration archivaConfiguration;
    @Inject
    @Named(value="repositoryStatisticsManager#default")
    private RepositoryStatisticsManager repositoryStatisticsManager;
    @Inject
    private RepositorySessionFactory repositorySessionFactory;
    private static final String REPOSITORY_SCAN_GROUP = "rg";
    private static final String REPOSITORY_JOB = "rj";
    private static final String REPOSITORY_JOB_TRIGGER = "rjt";
    static final String TASK_QUEUE = "TASK_QUEUE";
    static final String TASK_REPOSITORY = "TASK_REPOSITORY";
    public static final String CRON_HOURLY = "0 0 * * * ?";
    private Set<String> jobs = new HashSet<String>();
    private List<String> queuedRepos = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void startup() throws ArchivaException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.archivaConfiguration.addListener((ConfigurationListener)this);
        List repositories = this.archivaConfiguration.getConfiguration().getManagedRepositories();
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            MetadataRepository metadataRepository = repositorySession.getRepository();
            for (ManagedRepositoryConfiguration repoConfig : repositories) {
                if (!repoConfig.isScanned()) continue;
                try {
                    this.scheduleRepositoryJobs(repoConfig);
                }
                catch (SchedulerException e) {
                    throw new ArchivaException("Unable to start scheduler: " + e.getMessage(), (Throwable)e);
                }
                try {
                    if (this.isPreviouslyScanned(repoConfig, metadataRepository)) continue;
                    this.queueInitialRepoScan(repoConfig);
                }
                catch (MetadataRepositoryException e) {
                    this.log.warn("Unable to determine if a repository is already scanned, skipping initial scan: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        stopWatch.stop();
        this.log.info("Time to initalize DefaultRepositoryArchivaTaskScheduler: {} ms", (Object)stopWatch.getTime());
    }

    @PreDestroy
    public void stop() throws SchedulerException {
        for (String job : this.jobs) {
            this.scheduler.unscheduleJob(job, REPOSITORY_SCAN_GROUP);
        }
        this.jobs.clear();
        this.queuedRepos.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessingRepositoryTask(String repositoryId) {
        TaskQueue taskQueue = this.repositoryScanningQueue;
        synchronized (taskQueue) {
            List queue = null;
            try {
                queue = this.repositoryScanningQueue.getQueueSnapshot();
            }
            catch (TaskQueueException taskQueueException) {
                // empty catch block
            }
            for (RepositoryTask queuedTask : queue) {
                if (!queuedTask.getRepositoryId().equals(repositoryId)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessingRepositoryTask(RepositoryTask task) {
        TaskQueue taskQueue = this.repositoryScanningQueue;
        synchronized (taskQueue) {
            List queue = null;
            try {
                queue = this.repositoryScanningQueue.getQueueSnapshot();
            }
            catch (TaskQueueException taskQueueException) {
                // empty catch block
            }
            for (RepositoryTask queuedTask : queue) {
                if (!task.equals((Object)queuedTask)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueTask(RepositoryTask task) throws TaskQueueException {
        TaskQueue taskQueue = this.repositoryScanningQueue;
        synchronized (taskQueue) {
            if (this.isProcessingRepositoryTask(task)) {
                this.log.debug("Repository task '{}' is already queued. Skipping task.", (Object)task);
            } else {
                this.repositoryScanningQueue.put((Task)task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unQueueTask(RepositoryTask task) throws TaskQueueException {
        TaskQueue taskQueue = this.repositoryScanningQueue;
        synchronized (taskQueue) {
            if (!this.isProcessingRepositoryTask(task)) {
                this.log.info("cannot unqueue Repository task '{}' not already queued.", (Object)task);
                return false;
            }
            return this.repositoryScanningQueue.remove((Task)task);
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 1) {
            for (String job : this.jobs) {
                try {
                    this.scheduler.unscheduleJob(job, REPOSITORY_SCAN_GROUP);
                }
                catch (SchedulerException e) {
                    this.log.error("Error restarting the repository scanning job after property change.");
                }
            }
            this.jobs.clear();
            List repositories = this.archivaConfiguration.getConfiguration().getManagedRepositories();
            for (ManagedRepositoryConfiguration repoConfig : repositories) {
                if (repoConfig.getRefreshCronExpression() == null) continue;
                try {
                    this.scheduleRepositoryJobs(repoConfig);
                }
                catch (SchedulerException e) {
                    this.log.error("error restarting job: '{}' : '{}'", (Object)REPOSITORY_JOB, (Object)repoConfig.getId());
                }
            }
        }
    }

    private boolean isPreviouslyScanned(ManagedRepositoryConfiguration repoConfig, MetadataRepository metadataRepository) throws MetadataRepositoryException {
        long start = System.currentTimeMillis();
        boolean res = this.repositoryStatisticsManager.hasStatistics(metadataRepository, repoConfig.getId());
        long end = System.currentTimeMillis();
        this.log.debug("isPreviouslyScanned repo {} {} time: {} ms", new Object[]{repoConfig.getId(), res, end - start});
        return res;
    }

    private synchronized void queueInitialRepoScan(ManagedRepositoryConfiguration repoConfig) {
        String repoId = repoConfig.getId();
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repoId);
        if (!this.queuedRepos.contains(repoId)) {
            this.log.info("Repository [{}] is queued to be scanned as it hasn't been previously.", (Object)repoId);
            try {
                this.queuedRepos.add(repoConfig.getId());
                this.queueTask(task);
            }
            catch (TaskQueueException e) {
                this.log.error("Error occurred while queueing repository [{}] task : {}", (Object)e.getMessage(), (Object)repoId);
            }
        }
    }

    private synchronized void scheduleRepositoryJobs(ManagedRepositoryConfiguration repoConfig) throws SchedulerException {
        if (repoConfig.getRefreshCronExpression() == null) {
            this.log.warn("Skipping job, no cron expression for {}", (Object)repoConfig.getId());
            return;
        }
        if (!repoConfig.isScanned()) {
            this.log.warn("Skipping job, repository scannable has been disabled for {}", (Object)repoConfig.getId());
            return;
        }
        String cronString = repoConfig.getRefreshCronExpression();
        if (!this.cronValidator.validate(cronString)) {
            this.log.warn("Cron expression [{}] for repository [{}] is invalid.  Defaulting to hourly.", (Object)cronString, (Object)repoConfig.getId());
            cronString = CRON_HOURLY;
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(TASK_QUEUE, (Object)this.repositoryScanningQueue);
        jobDataMap.put(TASK_REPOSITORY, repoConfig.getId());
        JobDetail repositoryJob = JobBuilder.newJob(RepositoryTaskJob.class).withIdentity("rj:" + repoConfig.getId(), REPOSITORY_SCAN_GROUP).setJobData(jobDataMap).build();
        try {
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("rjt:" + repoConfig.getId(), REPOSITORY_SCAN_GROUP).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronString)).build();
            this.jobs.add("rj:" + repoConfig.getId());
            this.scheduler.scheduleJob(repositoryJob, (Trigger)trigger);
        }
        catch (RuntimeException e) {
            this.log.error("ParseException in repository scanning cron expression, disabling repository scanning for '': {}", (Object)repoConfig.getId(), (Object)e.getMessage());
        }
    }
}

