/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.scheduler.repository;

import java.util.Date;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.metadata.repository.stats.RepositoryStatistics;
import org.apache.archiva.metadata.repository.stats.RepositoryStatisticsManager;
import org.apache.archiva.redback.components.taskqueue.Task;
import org.apache.archiva.redback.components.taskqueue.execution.TaskExecutionException;
import org.apache.archiva.redback.components.taskqueue.execution.TaskExecutor;
import org.apache.archiva.repository.scanner.RepositoryContentConsumers;
import org.apache.archiva.repository.scanner.RepositoryScanStatistics;
import org.apache.archiva.repository.scanner.RepositoryScanner;
import org.apache.archiva.repository.scanner.RepositoryScannerException;
import org.apache.archiva.scheduler.repository.model.RepositoryTask;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="taskExecutor#repository-scanning")
public class ArchivaRepositoryScanningTaskExecutor
implements TaskExecutor<RepositoryTask> {
    private Logger log = LoggerFactory.getLogger(ArchivaRepositoryScanningTaskExecutor.class);
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private RepositoryScanner repoScanner;
    @Inject
    private RepositoryContentConsumers consumers;
    private Task task;
    @Inject
    private RepositoryStatisticsManager repositoryStatisticsManager;
    @Inject
    private RepositorySessionFactory repositorySessionFactory;

    @PostConstruct
    public void initialize() throws InitializationException {
        this.log.info("Initialized {}", (Object)this.getClass().getName());
    }

    public void executeTask(RepositoryTask task) throws TaskExecutionException {
        block13: {
            try {
                this.task = task;
                String repoId = task.getRepositoryId();
                if (StringUtils.isBlank((String)repoId)) {
                    throw new TaskExecutionException("Unable to execute RepositoryTask with blank repository Id.");
                }
                ManagedRepository arepo = this.managedRepositoryAdmin.getManagedRepository(repoId);
                if (task.getResourceFile() != null) {
                    this.log.debug("Executing task from queue with job name: {}", (Object)task);
                    this.consumers.executeConsumers(arepo, task.getResourceFile(), task.isUpdateRelatedArtifacts());
                    break block13;
                }
                this.log.info("Executing task from queue with job name: {}", (Object)task);
                if (arepo == null) {
                    throw new TaskExecutionException("Unable to execute RepositoryTask with invalid repository id: " + repoId);
                }
                long sinceWhen = 0L;
                long previousFileCount = 0L;
                RepositorySession repositorySession = this.repositorySessionFactory.createSession();
                MetadataRepository metadataRepository = repositorySession.getRepository();
                try {
                    RepositoryScanStatistics stats;
                    RepositoryStatistics previousStats;
                    if (!task.isScanAll() && (previousStats = this.repositoryStatisticsManager.getLastStatistics(metadataRepository, repoId)) != null) {
                        sinceWhen = previousStats.getScanStartTime().getTime();
                        previousFileCount = previousStats.getTotalFileCount();
                    }
                    try {
                        stats = this.repoScanner.scan(arepo, sinceWhen);
                    }
                    catch (RepositoryScannerException e) {
                        throw new TaskExecutionException("Repository error when executing repository job.", (Throwable)e);
                    }
                    this.log.info("Finished first scan: {}", (Object)stats.toDump(arepo));
                    Date endTime = new Date(stats.getWhenGathered().getTime() + stats.getDuration());
                    this.log.info("Gathering repository statistics");
                    this.repositoryStatisticsManager.addStatisticsAfterScan(metadataRepository, repoId, stats.getWhenGathered(), endTime, stats.getTotalFileCount(), stats.getTotalFileCount() - previousFileCount);
                    repositorySession.save();
                }
                catch (MetadataRepositoryException e) {
                    throw new TaskExecutionException("Unable to store updated statistics: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    repositorySession.close();
                }
                this.log.info("Finished repository task: {}", (Object)task);
                this.task = null;
            }
            catch (RepositoryAdminException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new TaskExecutionException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Task getCurrentTaskInExecution() {
        return this.task;
    }

    public RepositoryScanner getRepoScanner() {
        return this.repoScanner;
    }

    public void setRepoScanner(RepositoryScanner repoScanner) {
        this.repoScanner = repoScanner;
    }

    public RepositoryContentConsumers getConsumers() {
        return this.consumers;
    }

    public void setConsumers(RepositoryContentConsumers consumers) {
        this.consumers = consumers;
    }

    public RepositorySessionFactory getRepositorySessionFactory() {
        return this.repositorySessionFactory;
    }

    public void setRepositorySessionFactory(RepositorySessionFactory repositorySessionFactory) {
        this.repositorySessionFactory = repositorySessionFactory;
    }

    public RepositoryStatisticsManager getRepositoryStatisticsManager() {
        return this.repositoryStatisticsManager;
    }

    public void setRepositoryStatisticsManager(RepositoryStatisticsManager repositoryStatisticsManager) {
        this.repositoryStatisticsManager = repositoryStatisticsManager;
    }

    public ManagedRepositoryAdmin getManagedRepositoryAdmin() {
        return this.managedRepositoryAdmin;
    }

    public void setManagedRepositoryAdmin(ManagedRepositoryAdmin managedRepositoryAdmin) {
        this.managedRepositoryAdmin = managedRepositoryAdmin;
    }
}

