/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.maven2.metadata;

import java.io.File;
import java.util.Date;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.model.Plugin;
import org.apache.archiva.model.SnapshotVersion;
import org.apache.archiva.xml.XMLException;
import org.apache.archiva.xml.XMLReader;
import org.apache.commons.lang.math.NumberUtils;
import org.dom4j.Element;

public class MavenMetadataReader {
    public static ArchivaRepositoryMetadata read(File metadataFile) throws XMLException {
        XMLReader xml = new XMLReader("metadata", metadataFile);
        xml.removeNamespaces();
        ArchivaRepositoryMetadata metadata = new ArchivaRepositoryMetadata();
        metadata.setGroupId(xml.getElementText("//metadata/groupId"));
        metadata.setArtifactId(xml.getElementText("//metadata/artifactId"));
        metadata.setVersion(xml.getElementText("//metadata/version"));
        metadata.setFileLastModified(new Date(metadataFile.lastModified()));
        metadata.setFileSize(metadataFile.length());
        metadata.setLastUpdated(xml.getElementText("//metadata/versioning/lastUpdated"));
        metadata.setLatestVersion(xml.getElementText("//metadata/versioning/latest"));
        metadata.setReleasedVersion(xml.getElementText("//metadata/versioning/release"));
        metadata.setAvailableVersions(xml.getElementListText("//metadata/versioning/versions/version"));
        Element snapshotElem = xml.getElement("//metadata/versioning/snapshot");
        if (snapshotElem != null) {
            SnapshotVersion snapshot = new SnapshotVersion();
            snapshot.setTimestamp(snapshotElem.elementTextTrim("timestamp"));
            String tmp = snapshotElem.elementTextTrim("buildNumber");
            if (NumberUtils.isNumber((String)tmp)) {
                snapshot.setBuildNumber(NumberUtils.toInt((String)tmp));
            }
            metadata.setSnapshotVersion(snapshot);
        }
        for (Element plugin : xml.getElementList("//metadata/plugins/plugin")) {
            Plugin p = new Plugin();
            p.setPrefix(plugin.elementTextTrim("prefix"));
            p.setArtifactId(plugin.elementTextTrim("artifactId"));
            p.setName(plugin.elementTextTrim("name"));
            metadata.addPlugin(p);
        }
        return metadata;
    }
}

