/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.authentication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.archiva.redback.authentication.EncryptionFailedException;
import org.apache.archiva.redback.authentication.InvalidTokenException;
import org.apache.archiva.redback.authentication.SimpleTokenData;
import org.apache.archiva.redback.authentication.TokenData;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="tokenManager#jce")
public class TokenManager {
    private final ThreadLocal<SecureRandom> rd = new ThreadLocal();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String algorithm = "AES/CBC/PKCS5Padding";
    private int keySize = -1;
    private int ivSize = -1;
    private SecretKey secretKey;
    boolean paddingUsed = true;

    @PostConstruct
    public void initialize() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, EncryptionFailedException, InvalidAlgorithmParameterException {
        this.log.debug("Initializing key for token generator");
        try {
            this.rd.set(new SecureRandom());
            Cipher enCipher = Cipher.getInstance(this.algorithm);
            String[] keyAlg = enCipher.getAlgorithm().split("/");
            if (keyAlg.length < 1) {
                throw new EncryptionFailedException("Initialization of key failed. Not algorithm found.");
            }
            String encryptionAlgorithm = keyAlg[0];
            KeyGenerator keyGen = KeyGenerator.getInstance(encryptionAlgorithm);
            if (this.keySize > 0) {
                keyGen.init(this.keySize);
            }
            if (keyAlg.length == 3 && keyAlg[2].equals("NoPadding")) {
                this.paddingUsed = false;
            }
            this.secretKey = keyGen.generateKey();
            enCipher.init(1, this.secretKey);
            this.ivSize = enCipher.getIV() == null ? -1 : enCipher.getIV().length;
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Error occurred during key initialization. Requested algorithm not available. " + e.getMessage());
            throw e;
        }
        catch (NoSuchPaddingException e) {
            this.log.error("Error occurred during key initialization. Requested padding not available. " + e.getMessage());
            throw e;
        }
        catch (InvalidKeyException e) {
            this.log.error("The key is not valid.");
            throw e;
        }
    }

    public String encryptToken(String user, long lifetime) throws EncryptionFailedException {
        return this.encryptToken(new SimpleTokenData(user, lifetime, this.createNonce()));
    }

    public String encryptToken(TokenData tokenData) throws EncryptionFailedException {
        try {
            return this.encode(this.encrypt(tokenData));
        }
        catch (IOException e) {
            this.log.error("Error during object conversion: " + e.getMessage());
            throw new EncryptionFailedException(e);
        }
        catch (BadPaddingException e) {
            this.log.error("Padding invalid");
            throw new EncryptionFailedException(e);
        }
        catch (IllegalBlockSizeException e) {
            this.log.error("Block size invalid");
            throw new EncryptionFailedException(e);
        }
        catch (NoSuchPaddingException e) {
            this.log.error("Padding not available " + this.algorithm);
            throw new EncryptionFailedException(e);
        }
        catch (InvalidKeyException e) {
            this.log.error("Bad encryption key");
            throw new EncryptionFailedException(e);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Bad encryption algorithm " + this.algorithm);
            throw new EncryptionFailedException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            this.log.error("Invalid encryption parameters");
            throw new EncryptionFailedException(e);
        }
    }

    public TokenData decryptToken(String token) throws InvalidTokenException {
        try {
            return this.decrypt(this.decode(token));
        }
        catch (IOException ex) {
            this.log.error("Error during data read. " + ex.getMessage());
            throw new InvalidTokenException(ex);
        }
        catch (ClassNotFoundException ex) {
            this.log.error("Token data invalid.");
            throw new InvalidTokenException(ex);
        }
        catch (BadPaddingException ex) {
            this.log.error("The encrypted token has the wrong padding.");
            throw new InvalidTokenException(ex);
        }
        catch (IllegalBlockSizeException ex) {
            this.log.error("The encrypted token has the wrong block size.");
            throw new InvalidTokenException(ex);
        }
        catch (NoSuchPaddingException e) {
            this.log.error("Padding not available " + this.algorithm);
            throw new InvalidTokenException(e);
        }
        catch (InvalidKeyException e) {
            this.log.error("Invalid decryption key");
            throw new InvalidTokenException(e);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Encryption algorithm not available " + this.algorithm);
            throw new InvalidTokenException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            this.log.error("Invalid encryption parameters");
            throw new InvalidTokenException(e);
        }
    }

    private long createNonce() {
        if (this.rd.get() == null) {
            this.rd.set(new SecureRandom());
        }
        return this.rd.get().nextLong();
    }

    protected byte[] encrypt(TokenData info) throws IOException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        return this.doEncrypt(this.convertToByteArray(info), info.getNonce());
    }

    private byte[] getIv(long nonce) {
        byte[] iv = new byte[this.ivSize];
        SecureRandom sr = this.getRandomGenerator();
        sr.setSeed(nonce);
        sr.nextBytes(iv);
        return iv;
    }

    protected byte[] doEncrypt(byte[] data, long nonce) throws BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] encData;
        byte[] iv;
        Cipher cipher = this.getEnCipher();
        if (this.ivSize > 0) {
            iv = this.getIv(nonce);
            cipher.init(1, (Key)this.secretKey, new IvParameterSpec(iv));
        } else {
            iv = new byte[]{};
            cipher.init(1, this.secretKey);
        }
        if (!this.paddingUsed && data.length % cipher.getBlockSize() != 0) {
            int blocks = data.length / cipher.getBlockSize();
            encData = Arrays.copyOf(data, cipher.getBlockSize() * (blocks + 1));
        } else {
            encData = data;
        }
        byte[] encrypted = cipher.doFinal(encData);
        return ArrayUtils.addAll((byte[])iv, (byte[])encrypted);
    }

    protected TokenData decrypt(byte[] token) throws BadPaddingException, IllegalBlockSizeException, IOException, ClassNotFoundException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        Object result = this.convertFromByteArray(this.doDecrypt(token));
        if (!(result instanceof TokenData)) {
            throw new InvalidClassException("No TokenData found in decrypted token");
        }
        return (TokenData)result;
    }

    protected byte[] doDecrypt(byte[] encryptedData) throws BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = this.getDeCipher();
        if (this.ivSize > 0) {
            byte[] iv = Arrays.copyOfRange(encryptedData, 0, this.ivSize);
            cipher.init(2, (Key)this.secretKey, new IvParameterSpec(iv));
            return cipher.doFinal(encryptedData, this.ivSize, encryptedData.length - this.ivSize);
        }
        cipher.init(2, this.secretKey);
        return cipher.doFinal(encryptedData);
    }

    private SecureRandom getRandomGenerator() {
        if (this.rd.get() == null) {
            this.rd.set(new SecureRandom());
        }
        return this.rd.get();
    }

    private Cipher getEnCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        return Cipher.getInstance(this.algorithm);
    }

    private Cipher getDeCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        return Cipher.getInstance(this.algorithm);
    }

    private String encode(byte[] token) {
        return Base64.encodeBase64String((byte[])token);
    }

    private byte[] decode(String token) {
        return Base64.decodeBase64((String)token);
    }

    private Object convertFromByteArray(byte[] byteObject) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(byteObject);
        ObjectInputStream in = new ObjectInputStream(bais);
        Object o = in.readObject();
        in.close();
        return o;
    }

    private byte[] convertToByteArray(Object complexObject) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(complexObject);
        out.close();
        return baos.toByteArray();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        if (!this.algorithm.equals(algorithm)) {
            this.algorithm = algorithm;
            this.keySize = -1;
        }
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }
}

