/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.authentication;

import java.io.Serializable;
import java.util.Date;
import org.apache.archiva.redback.authentication.TokenData;

public final class SimpleTokenData
implements Serializable,
TokenData {
    private static final long serialVersionUID = 5907745449771921813L;
    private final String user;
    private final Date created;
    private final Date validBefore;
    private final long nonce;

    public SimpleTokenData(String user, long lifetime, long nonce) {
        this.user = user;
        this.created = new Date();
        this.validBefore = new Date(this.created.getTime() + lifetime);
        this.nonce = nonce;
    }

    @Override
    public final String getUser() {
        return this.user;
    }

    @Override
    public final Date created() {
        return this.created;
    }

    @Override
    public final Date validBefore() {
        return this.validBefore;
    }

    @Override
    public final long getNonce() {
        return this.nonce;
    }

    @Override
    public boolean isValid() {
        return new Date().getTime() < this.validBefore.getTime();
    }
}

