/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.authentication;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationFailureCause;
import org.apache.archiva.redback.authentication.AuthenticationManager;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authentication.Authenticator;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="authenticationManager")
public class DefaultAuthenticationManager
implements AuthenticationManager {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private List<Authenticator> authenticators;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    @Named(value="userManager#default")
    private UserManager userManager;

    @PostConstruct
    public void initialize() {
        this.authenticators = new ArrayList(this.applicationContext.getBeansOfType(Authenticator.class).values());
    }

    @Override
    public String getId() {
        return "Default Authentication Manager - " + this.getClass().getName() + " : managed authenticators - " + this.knownAuthenticators();
    }

    @Override
    public AuthenticationResult authenticate(AuthenticationDataSource source) throws AccountLockedException, AuthenticationException, MustChangePasswordException {
        if (this.authenticators == null || this.authenticators.size() == 0) {
            return new AuthenticationResult(false, null, new AuthenticationException("no valid authenticators, can't authenticate"));
        }
        ArrayList<AuthenticationFailureCause> authnResultErrors = new ArrayList<AuthenticationFailureCause>();
        for (Authenticator authenticator : this.authenticators) {
            if (authenticator.isValid()) {
                if (!authenticator.supportsDataSource(source)) continue;
                AuthenticationResult authResult = authenticator.authenticate(source);
                List<AuthenticationFailureCause> authenticationFailureCauses = authResult.getAuthenticationFailureCauses();
                if (authResult.isAuthenticated()) {
                    for (AuthenticationFailureCause authenticationFailureCause : authenticationFailureCauses) {
                        User user = authenticationFailureCause.getUser();
                        if (user == null || user.getCountFailedLoginAttempts() <= 0) continue;
                        user.setCountFailedLoginAttempts(0);
                        if (this.userManager.isReadOnly()) continue;
                        try {
                            this.userManager.updateUser(user);
                        }
                        catch (UserManagerException e) {
                            this.log.debug(e.getMessage(), (Throwable)e);
                            this.log.warn("skip error updating user: {}", (Object)e.getMessage());
                        }
                    }
                    return authResult;
                }
                if (authenticationFailureCauses != null) {
                    authnResultErrors.addAll(authenticationFailureCauses);
                    continue;
                }
                if (authResult.getException() == null) continue;
                authnResultErrors.add(new AuthenticationFailureCause(2, authResult.getException().getMessage()));
                continue;
            }
            this.log.warn("Invalid authenticator found: " + authenticator.getId());
        }
        return new AuthenticationResult(false, null, new AuthenticationException("authentication failed on authenticators: " + this.knownAuthenticators()), authnResultErrors);
    }

    @Override
    public List<Authenticator> getAuthenticators() {
        return this.authenticators;
    }

    private String knownAuthenticators() {
        StringBuilder strbuf = new StringBuilder();
        for (Authenticator authenticator : this.authenticators) {
            strbuf.append('(').append(authenticator.getId()).append(") ");
        }
        return strbuf.toString();
    }
}

