/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.archiva.xml.LatinEntities;

public class LatinEntityResolutionReader
extends Reader {
    private BufferedReader originalReader;
    private char[] leftover;
    private Pattern entityPattern;

    public LatinEntityResolutionReader(Reader reader) {
        this.originalReader = new BufferedReader(reader);
        this.entityPattern = Pattern.compile("\\&[a-zA-Z]+\\;");
    }

    @Override
    public int read(char[] destbuf, int offset, int length) throws IOException {
        StringBuilder sbuf;
        int tmpLength;
        int currentRequestedOffset = offset;
        int currentRequestedLength = length;
        if (this.leftover != null) {
            if (this.leftover.length > length) {
                System.arraycopy(this.leftover, 0, destbuf, currentRequestedOffset, length);
                int copyLeftOverLength = this.leftover.length - length;
                char[] tmp = new char[copyLeftOverLength];
                System.arraycopy(this.leftover, length, tmp, 0, copyLeftOverLength);
                this.leftover = new char[tmp.length];
                System.arraycopy(tmp, 0, this.leftover, 0, copyLeftOverLength);
                return length;
            }
            tmpLength = this.leftover.length;
            System.arraycopy(this.leftover, 0, destbuf, currentRequestedOffset, tmpLength);
            this.leftover = null;
            currentRequestedOffset += tmpLength;
            currentRequestedLength -= tmpLength;
        }
        if ((sbuf = this.getExpandedBuffer(currentRequestedLength)) == null) {
            if (currentRequestedOffset > offset) {
                return currentRequestedOffset - offset;
            }
            return -1;
        }
        tmpLength = Math.min(sbuf.length(), currentRequestedLength);
        sbuf.getChars(0, tmpLength, destbuf, currentRequestedOffset);
        if (tmpLength < sbuf.length()) {
            this.leftover = new char[sbuf.length() - tmpLength];
            sbuf.getChars(tmpLength, tmpLength + this.leftover.length, this.leftover, 0);
        }
        return currentRequestedOffset - offset + tmpLength;
    }

    private StringBuilder getExpandedBuffer(int minimumLength) throws IOException {
        boolean done;
        StringBuilder buf = null;
        String line = this.originalReader.readLine();
        boolean bl = done = line == null;
        while (!done) {
            if (buf == null) {
                buf = new StringBuilder();
            }
            buf.append(this.expandLine(line));
            if (this.originalReader.ready()) {
                buf.append("\n");
            }
            if (buf.length() > minimumLength) {
                done = true;
                continue;
            }
            line = this.originalReader.readLine();
            done = line == null;
        }
        return buf;
    }

    private String expandLine(String line) {
        StringBuilder ret = new StringBuilder();
        int offset = 0;
        Matcher mat = this.entityPattern.matcher(line);
        while (mat.find(offset)) {
            ret.append(line.substring(offset, mat.start()));
            String entity = mat.group();
            ret.append(LatinEntities.resolveEntity(entity));
            offset = mat.start() + entity.length();
        }
        ret.append(line.substring(offset));
        return ret.toString();
    }

    @Override
    public void close() throws IOException {
        this.originalReader.close();
    }
}

