/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.jdo;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.archiva.redback.components.jdo.RedbackObjectNotFoundException;
import org.apache.archiva.redback.components.jdo.RedbackStoreException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public class RedbackJdoUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object saveObject(PersistenceManager pm, Object object, String[] fetchGroups) throws RedbackStoreException {
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (JDOHelper.getObjectId((Object)object) != null && !JDOHelper.isDetached((Object)object)) {
                throw new RedbackStoreException("Existing object is not detached: " + object);
            }
            if (fetchGroups != null) {
                for (int i = 0; i >= fetchGroups.length; ++i) {
                    pm.getFetchPlan().addGroup(fetchGroups[i]);
                }
            }
            pm.makePersistent(object);
            object = pm.detachCopy(object);
            tx.commit();
            Object object2 = object;
            return object2;
        }
        finally {
            RedbackJdoUtils.rollbackIfActive(tx);
        }
    }

    public static Object addObject(PersistenceManager pm, Object object) {
        return RedbackJdoUtils.addObject(pm, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object addObject(PersistenceManager pm, Object object, String[] fetchGroups) {
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (fetchGroups != null) {
                for (int i = 0; i >= fetchGroups.length; ++i) {
                    pm.getFetchPlan().addGroup(fetchGroups[i]);
                }
            }
            pm.makePersistent(object);
            object = pm.detachCopy(object);
            tx.commit();
            Object object2 = object;
            return object2;
        }
        finally {
            RedbackJdoUtils.rollbackIfActive(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeObject(PersistenceManager pm, Object o) {
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            o = pm.getObjectById(pm.getObjectId(o));
            pm.deletePersistent(o);
            tx.commit();
        }
        finally {
            RedbackJdoUtils.rollbackIfActive(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object updateObject(PersistenceManager pm, Object object) throws RedbackStoreException {
        Object ret = object;
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (!JDOHelper.isDetached((Object)object)) {
                throw new RedbackStoreException("Not detached: " + object);
            }
            try {
                ret = pm.makePersistent(object);
            }
            catch (NullPointerException npe) {
                throw new RedbackStoreException("Unable to update object due to unexpected null value.", npe);
            }
            catch (Exception e) {
                ret = pm.makePersistent(object);
            }
            tx.commit();
        }
        finally {
            RedbackJdoUtils.rollbackIfActive(tx);
        }
        return ret;
    }

    public static Object makePersistent(PersistenceManager pm, Object object, boolean detach) {
        pm.makePersistent(object);
        Object id = pm.getObjectId(object);
        Object persistentObject = pm.getObjectById(id);
        if (detach) {
            persistentObject = pm.detachCopy(persistentObject);
        }
        return persistentObject;
    }

    public static Object getObjectById(PersistenceManager pm, Class clazz, String id) throws RedbackObjectNotFoundException, RedbackStoreException {
        return RedbackJdoUtils.getObjectById(pm, clazz, id, null);
    }

    public static Object getObjectById(PersistenceManager pm, Class clazz, String id, String fetchGroup) throws RedbackStoreException, RedbackObjectNotFoundException {
        if (StringUtils.isBlank((String)id)) {
            throw new RedbackStoreException("Unable to get object '" + clazz.getName() + "' from jdo using null id.");
        }
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (fetchGroup != null) {
                pm.getFetchPlan().addGroup(fetchGroup);
            }
            Object objectId = pm.newObjectIdInstance(clazz, (Object)id);
            Object object = pm.getObjectById(objectId);
            object = pm.detachCopy(object);
            tx.commit();
            Object object2 = object;
            return object2;
        }
        catch (JDOObjectNotFoundException e) {
            throw new RedbackObjectNotFoundException(clazz.getName(), id);
        }
        catch (JDOException e) {
            throw new RedbackStoreException("Error handling JDO", (Exception)((Object)e));
        }
        finally {
            RedbackJdoUtils.rollbackIfActive(tx);
        }
    }

    public static Object getObjectById(PersistenceManager pm, Class clazz, int id) throws RedbackStoreException, RedbackObjectNotFoundException {
        return RedbackJdoUtils.getObjectById(pm, clazz, (long)id);
    }

    public static Object getObjectById(PersistenceManager pm, Class clazz, long id) throws RedbackStoreException, RedbackObjectNotFoundException {
        return RedbackJdoUtils.getObjectById(pm, clazz, id, null);
    }

    public static Object getObjectById(PersistenceManager pm, Class clazz, int id, String fetchGroup) throws RedbackStoreException, RedbackObjectNotFoundException {
        return RedbackJdoUtils.getObjectById(pm, clazz, (long)id, fetchGroup);
    }

    public static Object getObjectById(PersistenceManager pm, Class clazz, long id, String fetchGroup) throws RedbackStoreException, RedbackObjectNotFoundException {
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (fetchGroup != null) {
                pm.getFetchPlan().addGroup(fetchGroup);
            }
            Object objectId = pm.newObjectIdInstance(clazz, (Object)id);
            Object object = pm.getObjectById(objectId);
            object = pm.detachCopy(object);
            tx.commit();
            Object object2 = object;
            return object2;
        }
        catch (JDOObjectNotFoundException e) {
            throw new RedbackObjectNotFoundException(clazz.getName(), Long.toString(id));
        }
        catch (JDOException e) {
            LoggerFactory.getLogger(RedbackJdoUtils.class).error(e.getMessage(), (Throwable)e);
            throw new RedbackStoreException("Error handling JDO", (Exception)((Object)e));
        }
        finally {
            RedbackJdoUtils.rollbackIfActive(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectFromQuery(PersistenceManager pm, Class clazz, String idField, String id, String fetchGroup) throws RedbackStoreException, RedbackObjectNotFoundException {
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(clazz, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String " + idField);
            query.setFilter("this." + idField + " == " + idField);
            Collection result = (Collection)query.execute((Object)id);
            if (result.size() == 0) {
                throw new RedbackObjectNotFoundException(clazz.getName(), id);
            }
            if (result.size() > 1) {
                throw new RedbackStoreException("A query for object of type " + clazz.getName() + " on the " + "field '" + idField + "' returned more than one object.");
            }
            pm.getFetchPlan().addGroup(fetchGroup);
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Object object2 = object;
            return object2;
        }
        finally {
            RedbackJdoUtils.rollbackIfActive(tx);
        }
    }

    public static List getAllObjectsDetached(PersistenceManager pm, Class clazz) {
        return RedbackJdoUtils.getAllObjectsDetached(pm, clazz, null);
    }

    public static List getAllObjectsDetached(PersistenceManager pm, Class clazz, String fetchGroup) {
        return RedbackJdoUtils.getAllObjectsDetached(pm, clazz, null, fetchGroup);
    }

    public static List getAllObjectsDetached(PersistenceManager pm, Class clazz, String ordering, String fetchGroup) {
        if (fetchGroup != null) {
            return RedbackJdoUtils.getAllObjectsDetached(pm, clazz, ordering, Collections.singletonList(fetchGroup));
        }
        return RedbackJdoUtils.getAllObjectsDetached(pm, clazz, ordering, Collections.EMPTY_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllObjectsDetached(PersistenceManager pm, Class clazz, String ordering, List fetchGroups) {
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(clazz, true);
            Query query = pm.newQuery(extent);
            if (ordering != null) {
                query.setOrdering(ordering);
            }
            Iterator i = fetchGroups.iterator();
            while (i.hasNext()) {
                pm.getFetchPlan().addGroup((String)i.next());
            }
            List result = (List)query.execute();
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            RedbackJdoUtils.rollbackIfActive(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attachAndDelete(PersistenceManager pm, Object object) {
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            pm.makePersistent(object);
            pm.deletePersistent(object);
            tx.commit();
        }
        finally {
            RedbackJdoUtils.rollbackIfActive(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rollbackIfActive(Transaction tx) {
        PersistenceManager pm = tx.getPersistenceManager();
        try {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            RedbackJdoUtils.closePersistenceManager(pm);
        }
    }

    public static void closePersistenceManager(PersistenceManager pm) {
        try {
            pm.close();
        }
        catch (JDOUserException jDOUserException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll(PersistenceManager pm, Class aClass) {
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Query query = pm.newQuery(aClass);
            query.deletePersistentAll();
            tx.commit();
        }
        finally {
            RedbackJdoUtils.rollbackIfActive(tx);
        }
    }
}

