/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.jdo;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import org.apache.archiva.redback.components.jdo.JdoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJdoFactory
implements JdoFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CONNECTION_DRIVER_NAME = "javax.jdo.option.ConnectionDriverName";
    private Properties properties;
    private PersistenceManagerFactory persistenceManagerFactory;

    @Override
    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    @PostConstruct
    public void initialize() {
        this.logger.info("Initializing JDO.");
        this.persistenceManagerFactory = JDOHelper.getPersistenceManagerFactory((Map)this.properties);
        String driverClass = null;
        try {
            driverClass = (String)this.properties.get(CONNECTION_DRIVER_NAME);
            if (driverClass == null) {
                throw new RuntimeException("Property javax.jdo.option.ConnectionDriverName was not set in JDO Factory.");
            }
            Thread.currentThread().getContextClassLoader().loadClass(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find driver class: " + driverClass, e);
        }
    }

    @Override
    public void shutdown() throws Exception {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void dispose() {
        String databaseUrl;
        if (this.properties != null && (databaseUrl = this.properties.getProperty("javax.jdo.option.ConnectionURL")) != null && databaseUrl.indexOf("jdbc:derby:") == 0) {
            String databasePath = databaseUrl.substring("jdbc:derby:".length());
            if (databasePath.indexOf(59) > 0) {
                databasePath = databasePath.substring(0, databasePath.indexOf(59));
            }
            Connection connection = null;
            try {
                DriverManager.getConnection("jdbc:derby:" + databasePath + ";shutdown=true");
            }
            catch (SQLException e) {
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
            }
            System.gc();
        }
    }
}

