/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.jdo;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.archiva.redback.components.jdo.AbstractConfigurableJdoFactory;
import org.apache.archiva.redback.components.jdo.ConfigurableJdoFactory;

public class DefaultConfigurableJdoFactory
extends AbstractConfigurableJdoFactory
implements ConfigurableJdoFactory {
    private String driverName;
    private String url;
    private String userName;
    private String password;

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws Exception {
        if (this.url != null && this.url.indexOf("jdbc:derby:") == 0) {
            String databasePath = this.url.substring("jdbc:derby:".length());
            if (databasePath.indexOf(59) > 0) {
                databasePath = databasePath.substring(0, databasePath.indexOf(59));
            }
            Connection connection = null;
            try {
                DriverManager.getConnection("jdbc:derby:" + databasePath + ";shutdown=true");
            }
            catch (SQLException e) {
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
            }
            System.gc();
        }
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() {
        Boolean bl = this.configured;
        synchronized (bl) {
            if (this.configured == Boolean.TRUE) {
                return this.properties;
            }
            Properties properties = new Properties();
            for (Map.Entry<Object, Object> entry : this.otherProperties.entrySet()) {
                properties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            this.setPropertyInner(properties, "javax.jdo.PersistenceManagerFactoryClass", this.persistenceManagerFactoryClass);
            this.setPropertyInner(properties, "javax.jdo.option.ConnectionDriverName", this.driverName);
            this.setPropertyInner(properties, "javax.jdo.option.ConnectionURL", this.url);
            this.setPropertyInner(properties, "javax.jdo.option.ConnectionUserName", this.userName);
            this.setPropertyInner(properties, "javax.jdo.option.ConnectionPassword", this.password);
            return properties;
        }
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }
}

