/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.jdo;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.archiva.redback.components.jdo.AbstractConfigurableJdoFactory;

public class DataSourceConfigurableJdoFactory
extends AbstractConfigurableJdoFactory {
    private String connectionFactoryName;
    private String shutdownConnectionFactoryName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() {
        Boolean bl = this.configured;
        synchronized (bl) {
            if (this.configured == Boolean.TRUE) {
                return this.properties;
            }
            Properties properties = new Properties();
            for (Map.Entry<Object, Object> entry : this.otherProperties.entrySet()) {
                properties.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            this.setPropertyInner(properties, "javax.jdo.PersistenceManagerFactoryClass", this.persistenceManagerFactoryClass);
            this.setPropertyInner(properties, "javax.jdo.option.ConnectionFactoryName", this.connectionFactoryName);
            return properties;
        }
    }

    @Override
    public void shutdown() throws Exception {
        if (this.shutdownConnectionFactoryName != null) {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.shutdownConnectionFactoryName);
            try {
                ds.getConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.shutdown();
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getShutdownConnectionFactoryName() {
        return this.shutdownConnectionFactoryName;
    }

    public void setShutdownConnectionFactoryName(String shutdownConnectionFactoryName) {
        this.shutdownConnectionFactoryName = shutdownConnectionFactoryName;
    }
}

