/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.jdo;

import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import org.apache.archiva.redback.components.jdo.ConfigurableJdoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurableJdoFactory
implements ConfigurableJdoFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String persistenceManagerFactoryClass;
    protected Boolean configured = Boolean.FALSE;
    protected Properties properties;
    private PersistenceManagerFactory pmf;
    protected Properties otherProperties;

    @PostConstruct
    public void initialize() {
        if (this.otherProperties == null) {
            this.otherProperties = new Properties();
        }
    }

    @Override
    public PersistenceManagerFactory getPersistenceManagerFactory() {
        if (this.configured == Boolean.FALSE) {
            this.configure();
        }
        return this.pmf;
    }

    @Override
    public void shutdown() throws Exception {
    }

    @Override
    public void setPersistenceManagerFactoryClass(String persistenceManagerFactoryClass) {
        this.persistenceManagerFactoryClass = persistenceManagerFactoryClass;
    }

    public void setProperty(String key, String value) {
        if (this.otherProperties == null) {
            this.otherProperties = new Properties();
        }
        this.setPropertyInner(this.otherProperties, key, value);
    }

    @Override
    public abstract Properties getProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure() {
        Boolean bl = this.configured;
        synchronized (bl) {
            if (this.configured == Boolean.TRUE) {
                return;
            }
            this.doConfigure();
        }
    }

    private void doConfigure() {
        Properties properties = this.getProperties();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Configuring JDO Factory.");
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.logger.debug("{}={}", entry.getKey(), entry.getValue());
            }
        }
        this.pmf = JDOHelper.getPersistenceManagerFactory((Map)properties);
        this.properties = properties;
        this.configured = Boolean.TRUE;
    }

    protected void setPropertyInner(Properties properties, String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null.");
        }
        if (value == null) {
            return;
        }
        properties.setProperty(key, value);
    }

    public Boolean getConfigured() {
        return this.configured;
    }

    public void setConfigured(Boolean configured) {
        this.configured = configured;
    }

    public Properties getOtherProperties() {
        return this.otherProperties;
    }

    public void setOtherProperties(Properties otherProperties) {
        this.otherProperties = otherProperties;
    }
}

