/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.scheduler.indexing;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.NetworkProxy;
import org.apache.archiva.admin.model.beans.RemoteRepository;
import org.apache.archiva.admin.model.remote.RemoteRepositoryAdmin;
import org.apache.archiva.proxy.common.WagonFactory;
import org.apache.archiva.proxy.common.WagonFactoryException;
import org.apache.archiva.proxy.common.WagonFactoryRequest;
import org.apache.archiva.scheduler.indexing.DownloadRemoteIndexTaskRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.providers.http.AbstractHttpClientWagon;
import org.apache.maven.wagon.providers.http.HttpConfiguration;
import org.apache.maven.wagon.providers.http.HttpMethodConfiguration;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRemoteIndexTask
implements Runnable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private RemoteRepository remoteRepository;
    private RemoteRepositoryAdmin remoteRepositoryAdmin;
    private WagonFactory wagonFactory;
    private NetworkProxy networkProxy;
    private boolean fullDownload;
    private List<String> runningRemoteDownloadIds;
    private IndexUpdater indexUpdater;

    public DownloadRemoteIndexTask(DownloadRemoteIndexTaskRequest downloadRemoteIndexTaskRequest, List<String> runningRemoteDownloadIds) {
        this.remoteRepository = downloadRemoteIndexTaskRequest.getRemoteRepository();
        this.wagonFactory = downloadRemoteIndexTaskRequest.getWagonFactory();
        this.networkProxy = downloadRemoteIndexTaskRequest.getNetworkProxy();
        this.fullDownload = downloadRemoteIndexTaskRequest.isFullDownload();
        this.runningRemoteDownloadIds = runningRemoteDownloadIds;
        this.indexUpdater = downloadRemoteIndexTaskRequest.getIndexUpdater();
        this.remoteRepositoryAdmin = downloadRemoteIndexTaskRequest.getRemoteRepositoryAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        List<String> list = this.runningRemoteDownloadIds;
        synchronized (list) {
            if (this.runningRemoteDownloadIds.contains(this.remoteRepository.getId())) {
                this.log.info("skip download index remote for repo {} it's already running", (Object)this.remoteRepository.getId());
                return;
            }
            this.runningRemoteDownloadIds.add(this.remoteRepository.getId());
        }
        File tempIndexDirectory = null;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.log.info("start download remote index for remote repository {}", (Object)this.remoteRepository.getId());
            IndexingContext indexingContext = this.remoteRepositoryAdmin.createIndexContext(this.remoteRepository);
            tempIndexDirectory = new File(indexingContext.getIndexDirectoryFile().getParent(), ".tmpIndex");
            File indexCacheDirectory = new File(indexingContext.getIndexDirectoryFile().getParent(), ".indexCache");
            indexCacheDirectory.mkdirs();
            if (tempIndexDirectory.exists()) {
                FileUtils.deleteDirectory((File)tempIndexDirectory);
            }
            tempIndexDirectory.mkdirs();
            tempIndexDirectory.deleteOnExit();
            String baseIndexUrl = indexingContext.getIndexUpdateUrl();
            String wagonProtocol = new URL(this.remoteRepository.getUrl()).getProtocol();
            StreamWagon wagon = (StreamWagon)this.wagonFactory.getWagon(new WagonFactoryRequest(wagonProtocol, this.remoteRepository.getExtraHeaders()).networkProxy(this.networkProxy));
            wagon.setReadTimeout(this.remoteRepository.getRemoteDownloadTimeout() * 1000);
            wagon.setTimeout(this.remoteRepository.getTimeout() * 1000);
            if (wagon instanceof AbstractHttpClientWagon) {
                HttpConfiguration httpConfiguration = new HttpConfiguration();
                HttpMethodConfiguration httpMethodConfiguration = new HttpMethodConfiguration();
                httpMethodConfiguration.setUsePreemptive(true);
                httpMethodConfiguration.setReadTimeout(this.remoteRepository.getRemoteDownloadTimeout() * 1000);
                httpConfiguration.setGet(httpMethodConfiguration);
                ((AbstractHttpClientWagon)AbstractHttpClientWagon.class.cast(wagon)).setHttpConfiguration(httpConfiguration);
            }
            wagon.addTransferListener((TransferListener)new DownloadListener());
            ProxyInfo proxyInfo = null;
            if (this.networkProxy != null) {
                proxyInfo = new ProxyInfo();
                proxyInfo.setType(this.networkProxy.getProtocol());
                proxyInfo.setHost(this.networkProxy.getHost());
                proxyInfo.setPort(this.networkProxy.getPort());
                proxyInfo.setUserName(this.networkProxy.getUsername());
                proxyInfo.setPassword(this.networkProxy.getPassword());
            }
            AuthenticationInfo authenticationInfo = null;
            if (this.remoteRepository.getUserName() != null) {
                authenticationInfo = new AuthenticationInfo();
                authenticationInfo.setUserName(this.remoteRepository.getUserName());
                authenticationInfo.setPassword(this.remoteRepository.getPassword());
            }
            wagon.connect(new Repository(this.remoteRepository.getId(), baseIndexUrl), authenticationInfo, proxyInfo);
            File indexDirectory = indexingContext.getIndexDirectoryFile();
            if (!indexDirectory.exists()) {
                indexDirectory.mkdirs();
            }
            WagonResourceFetcher resourceFetcher = new WagonResourceFetcher(this.log, tempIndexDirectory, (Wagon)wagon, this.remoteRepository);
            IndexUpdateRequest request = new IndexUpdateRequest(indexingContext, (ResourceFetcher)resourceFetcher);
            request.setForceFullUpdate(this.fullDownload);
            request.setLocalIndexCacheDir(indexCacheDirectory);
            this.indexUpdater.fetchAndUpdateIndex(request);
            stopWatch.stop();
            this.log.info("time update index from remote for repository {}: {} s", (Object)this.remoteRepository.getId(), (Object)(stopWatch.getTime() / 1000L));
            indexingContext.updateTimestamp(true);
            this.deleteDirectoryQuiet(tempIndexDirectory);
            this.runningRemoteDownloadIds.remove(this.remoteRepository.getId());
        }
        catch (MalformedURLException e) {
            try {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
                catch (WagonFactoryException e2) {
                    this.log.error(e2.getMessage(), (Throwable)e2);
                    throw new RuntimeException(e2.getMessage(), e2);
                }
                catch (ConnectionException e3) {
                    this.log.error(e3.getMessage(), (Throwable)e3);
                    throw new RuntimeException(e3.getMessage(), e3);
                }
                catch (AuthenticationException e4) {
                    this.log.error(e4.getMessage(), (Throwable)e4);
                    throw new RuntimeException(e4.getMessage(), e4);
                }
                catch (IOException e5) {
                    this.log.error(e5.getMessage(), (Throwable)e5);
                    throw new RuntimeException(e5.getMessage(), e5);
                }
                catch (RepositoryAdminException e6) {
                    this.log.error(e6.getMessage(), (Throwable)e6);
                    throw new RuntimeException(e6.getMessage(), e6);
                }
            }
            catch (Throwable throwable) {
                this.deleteDirectoryQuiet(tempIndexDirectory);
                this.runningRemoteDownloadIds.remove(this.remoteRepository.getId());
                throw throwable;
            }
        }
        this.log.info("end download remote index for remote repository {}", (Object)this.remoteRepository.getId());
    }

    private void deleteDirectoryQuiet(File f) {
        try {
            FileUtils.deleteDirectory((File)f);
        }
        catch (IOException e) {
            this.log.warn("skip error delete {} : {}", (Object)f, (Object)e.getMessage());
        }
    }

    private static class WagonResourceFetcher
    implements ResourceFetcher {
        Logger log;
        File tempIndexDirectory;
        Wagon wagon;
        RemoteRepository remoteRepository;

        private WagonResourceFetcher(Logger log, File tempIndexDirectory, Wagon wagon, RemoteRepository remoteRepository) {
            this.log = log;
            this.tempIndexDirectory = tempIndexDirectory;
            this.wagon = wagon;
            this.remoteRepository = remoteRepository;
        }

        public void connect(String id, String url) throws IOException {
        }

        public void disconnect() throws IOException {
        }

        public InputStream retrieve(String name) throws IOException, FileNotFoundException {
            try {
                this.log.info("index update retrieve file, name:{}", (Object)name);
                File file = new File(this.tempIndexDirectory, name);
                Files.deleteIfExists(file.toPath());
                file.deleteOnExit();
                this.wagon.get(this.addParameters(name, this.remoteRepository), file);
                return Files.newInputStream(file.toPath(), new OpenOption[0]);
            }
            catch (TransferFailedException | AuthorizationException e) {
                throw new IOException(e.getMessage(), e);
            }
            catch (ResourceDoesNotExistException e) {
                FileNotFoundException fnfe = new FileNotFoundException(e.getMessage());
                fnfe.initCause(e);
                throw fnfe;
            }
        }

        protected String addParameters(String path, RemoteRepository remoteRepository) {
            if (remoteRepository.getExtraParameters().isEmpty()) {
                return path;
            }
            boolean question = false;
            StringBuilder res = new StringBuilder(path == null ? "" : path);
            for (Map.Entry entry : remoteRepository.getExtraParameters().entrySet()) {
                if (question) continue;
                res.append('?').append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
            return res.toString();
        }
    }

    private static final class DownloadListener
    implements TransferListener {
        private Logger log = LoggerFactory.getLogger(this.getClass());
        private String resourceName;
        private long startTime;
        private int totalLength = 0;

        private DownloadListener() {
        }

        public void transferInitiated(TransferEvent transferEvent) {
            this.startTime = System.currentTimeMillis();
            this.resourceName = transferEvent.getResource().getName();
            this.log.debug("initiate transfer of {}", (Object)this.resourceName);
        }

        public void transferStarted(TransferEvent transferEvent) {
            this.totalLength = 0;
            this.resourceName = transferEvent.getResource().getName();
            this.log.info("start transfer of {}", (Object)transferEvent.getResource().getName());
        }

        public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
            this.log.debug("transfer of {} : {}/{}", new Object[]{transferEvent.getResource().getName(), buffer.length, length});
            this.totalLength += length;
        }

        public void transferCompleted(TransferEvent transferEvent) {
            this.resourceName = transferEvent.getResource().getName();
            long endTime = System.currentTimeMillis();
            this.log.info("end of transfer file {} {} kb: {}s", new Object[]{transferEvent.getResource().getName(), this.totalLength / 1024, (endTime - this.startTime) / 1000L});
        }

        public void transferError(TransferEvent transferEvent) {
            this.log.info("error of transfer file {}: {}", new Object[]{transferEvent.getResource().getName(), transferEvent.getException().getMessage(), transferEvent.getException()});
        }

        public void debug(String message) {
            this.log.debug("transfer debug {}", (Object)message);
        }
    }
}

