/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.scheduler.indexing;

import java.io.File;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.redback.components.taskqueue.Task;
import org.apache.maven.index.context.IndexingContext;

public class ArtifactIndexingTask
implements Task {
    private final ManagedRepository repository;
    private final File resourceFile;
    private final Action action;
    private final IndexingContext context;
    private boolean executeOnEntireRepo = true;
    private boolean onlyUpdate = false;

    public ArtifactIndexingTask(ManagedRepository repository, File resourceFile, Action action, IndexingContext context) {
        this.repository = repository;
        this.resourceFile = resourceFile;
        this.action = action;
        this.context = context;
    }

    public ArtifactIndexingTask(ManagedRepository repository, File resourceFile, Action action, IndexingContext context, boolean executeOnEntireRepo) {
        this(repository, resourceFile, action, context);
        this.executeOnEntireRepo = executeOnEntireRepo;
    }

    public ArtifactIndexingTask(ManagedRepository repository, File resourceFile, Action action, IndexingContext context, boolean executeOnEntireRepo, boolean onlyUpdate) {
        this(repository, resourceFile, action, context, executeOnEntireRepo);
        this.onlyUpdate = onlyUpdate;
    }

    public boolean isExecuteOnEntireRepo() {
        return this.executeOnEntireRepo;
    }

    public void setExecuteOnEntireRepo(boolean executeOnEntireRepo) {
        this.executeOnEntireRepo = executeOnEntireRepo;
    }

    public long getMaxExecutionTime() {
        return 0L;
    }

    public File getResourceFile() {
        return this.resourceFile;
    }

    public Action getAction() {
        return this.action;
    }

    public ManagedRepository getRepository() {
        return this.repository;
    }

    public IndexingContext getContext() {
        return this.context;
    }

    public boolean isOnlyUpdate() {
        return this.onlyUpdate;
    }

    public void setOnlyUpdate(boolean onlyUpdate) {
        this.onlyUpdate = onlyUpdate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.action.hashCode();
        result = 31 * result + this.repository.getId().hashCode();
        result = 31 * result + (this.resourceFile == null ? 0 : this.resourceFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactIndexingTask other = (ArtifactIndexingTask)obj;
        if (!this.action.equals((Object)other.action)) {
            return false;
        }
        if (!this.repository.getId().equals(other.repository.getId())) {
            return false;
        }
        return !(this.resourceFile == null ? other.resourceFile != null : !this.resourceFile.equals(other.resourceFile));
    }

    public String toString() {
        return "ArtifactIndexingTask [action=" + (Object)((Object)this.action) + ", repositoryId=" + this.repository.getId() + ", resourceFile=" + this.resourceFile + "]";
    }

    public static enum Action {
        ADD,
        DELETE,
        FINISH;

    }
}

