/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.scheduler.indexing;

import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridge;
import org.apache.archiva.common.plexusbridge.PlexusSisuBridgeException;
import org.apache.archiva.redback.components.taskqueue.Task;
import org.apache.archiva.redback.components.taskqueue.execution.TaskExecutionException;
import org.apache.archiva.redback.components.taskqueue.execution.TaskExecutor;
import org.apache.archiva.scheduler.indexing.ArtifactIndexingTask;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.packer.IndexPacker;
import org.apache.maven.index.packer.IndexPackingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="taskExecutor#indexing")
public class ArchivaIndexingTaskExecutor
implements TaskExecutor {
    private Logger log = LoggerFactory.getLogger(ArchivaIndexingTaskExecutor.class);
    private IndexPacker indexPacker;
    private ArtifactContextProducer artifactContextProducer;
    @Inject
    private PlexusSisuBridge plexusSisuBridge;
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    private NexusIndexer nexusIndexer;

    @PostConstruct
    public void initialize() throws PlexusSisuBridgeException {
        this.log.info("Initialized {}", (Object)this.getClass().getName());
        this.artifactContextProducer = (ArtifactContextProducer)this.plexusSisuBridge.lookup(ArtifactContextProducer.class);
        this.indexPacker = (IndexPacker)this.plexusSisuBridge.lookup(IndexPacker.class, "default");
        this.nexusIndexer = (NexusIndexer)this.plexusSisuBridge.lookup(NexusIndexer.class);
    }

    public void executeTask(Task task) throws TaskExecutionException {
        ArtifactIndexingTask indexingTask = (ArtifactIndexingTask)task;
        ManagedRepository repository = indexingTask.getRepository();
        IndexingContext context = indexingTask.getContext();
        if (ArtifactIndexingTask.Action.FINISH.equals((Object)indexingTask.getAction()) && indexingTask.isExecuteOnEntireRepo()) {
            try {
                long start = System.currentTimeMillis();
                this.nexusIndexer.scan(context, null, indexingTask.isOnlyUpdate());
                long end = System.currentTimeMillis();
                this.log.info("indexed maven repository: {}, onlyUpdate: {}, time {} ms", new Object[]{repository.getId(), indexingTask.isOnlyUpdate(), end - start});
            }
            catch (IOException e) {
                throw new TaskExecutionException("Error scan repository " + repository, (Throwable)e);
            }
            this.log.debug("Finishing indexing task on repo: {}", (Object)repository.getId());
            this.finishIndexingTask(indexingTask, repository, context);
        } else {
            if (!indexingTask.isExecuteOnEntireRepo()) {
                try {
                    this.log.debug("Creating indexing context on resource: {}", (Object)(indexingTask.getResourceFile() == null ? "none" : indexingTask.getResourceFile().getPath()));
                    context = this.managedRepositoryAdmin.createIndexContext(repository);
                }
                catch (RepositoryAdminException e) {
                    this.log.error("Error occurred while creating context: " + e.getMessage());
                    throw new TaskExecutionException("Error occurred while creating context: " + e.getMessage(), (Throwable)e);
                }
            }
            if (context == null || context.getIndexDirectory() == null) {
                throw new TaskExecutionException("Trying to index an artifact but the context is already closed");
            }
            try {
                File artifactFile = indexingTask.getResourceFile();
                if (artifactFile == null) {
                    this.log.debug("no artifact pass in indexing task so skip it");
                } else {
                    ArtifactContext ac = this.artifactContextProducer.getArtifactContext(context, artifactFile);
                    if (ac != null) {
                        if (artifactFile.getPath().endsWith(".pom")) {
                            ac.getArtifactInfo().fextension = "pom";
                            ac.getArtifactInfo().packaging = "pom";
                            ac.getArtifactInfo().classifier = "pom";
                        }
                        if (indexingTask.getAction().equals((Object)ArtifactIndexingTask.Action.ADD)) {
                            FlatSearchRequest flatSearchRequest;
                            FlatSearchResponse flatSearchResponse;
                            BooleanQuery q = new BooleanQuery();
                            q.add(this.nexusIndexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression(ac.getArtifactInfo().groupId)), BooleanClause.Occur.MUST);
                            q.add(this.nexusIndexer.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new SourcedSearchExpression(ac.getArtifactInfo().artifactId)), BooleanClause.Occur.MUST);
                            q.add(this.nexusIndexer.constructQuery(MAVEN.VERSION, (SearchExpression)new SourcedSearchExpression(ac.getArtifactInfo().version)), BooleanClause.Occur.MUST);
                            if (ac.getArtifactInfo().classifier != null) {
                                q.add(this.nexusIndexer.constructQuery(MAVEN.CLASSIFIER, (SearchExpression)new SourcedSearchExpression(ac.getArtifactInfo().classifier)), BooleanClause.Occur.MUST);
                            }
                            if (ac.getArtifactInfo().packaging != null) {
                                q.add(this.nexusIndexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression(ac.getArtifactInfo().packaging)), BooleanClause.Occur.MUST);
                            }
                            if ((flatSearchResponse = this.nexusIndexer.searchFlat(flatSearchRequest = new FlatSearchRequest((Query)q, context))).getResults().isEmpty()) {
                                this.log.debug("Adding artifact '{}' to index..", (Object)ac.getArtifactInfo());
                                this.nexusIndexer.addArtifactToIndex(ac, context);
                            } else {
                                this.log.debug("Updating artifact '{}' in index..", (Object)ac.getArtifactInfo());
                                this.nexusIndexer.deleteArtifactFromIndex(ac, context);
                                this.nexusIndexer.addArtifactToIndex(ac, context);
                            }
                            context.updateTimestamp();
                            context.commit();
                        } else {
                            this.log.debug("Removing artifact '{}' from index..", (Object)ac.getArtifactInfo());
                            this.nexusIndexer.deleteArtifactFromIndex(ac, context);
                        }
                    }
                }
                if (!indexingTask.isExecuteOnEntireRepo()) {
                    this.log.debug("Finishing indexing task on resource file : {}", (Object)(indexingTask.getResourceFile() != null ? indexingTask.getResourceFile().getPath() : " none "));
                    this.finishIndexingTask(indexingTask, repository, context);
                }
            }
            catch (IOException e) {
                this.log.error("Error occurred while executing indexing task '" + indexingTask + "': " + e.getMessage(), (Throwable)e);
                throw new TaskExecutionException("Error occurred while executing indexing task '" + indexingTask + "'", (Throwable)e);
            }
        }
    }

    private void finishIndexingTask(ArtifactIndexingTask indexingTask, ManagedRepository repository, IndexingContext context) throws TaskExecutionException {
        try {
            context.optimize();
            if (!repository.isSkipPackedIndexCreation()) {
                IndexPackingRequest request = new IndexPackingRequest(context, context.getIndexDirectoryFile());
                this.indexPacker.packIndex(request);
                context.updateTimestamp(true);
                this.log.debug("Index file packaged at '{}'.", (Object)context.getIndexDirectoryFile());
            } else {
                this.log.debug("skip packed index creation");
            }
        }
        catch (IOException e) {
            this.log.error("Error occurred while executing indexing task '" + indexingTask + "': " + e.getMessage());
            throw new TaskExecutionException("Error occurred while executing indexing task '" + indexingTask + "'", (Throwable)e);
        }
    }

    public void setIndexPacker(IndexPacker indexPacker) {
        this.indexPacker = indexPacker;
    }

    public PlexusSisuBridge getPlexusSisuBridge() {
        return this.plexusSisuBridge;
    }

    public void setPlexusSisuBridge(PlexusSisuBridge plexusSisuBridge) {
        this.plexusSisuBridge = plexusSisuBridge;
    }
}

