/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.archiva.configuration.CacheConfiguration;
import org.apache.archiva.configuration.LdapConfiguration;
import org.apache.archiva.configuration.LdapGroupMapping;

public class RedbackRuntimeConfiguration
implements Serializable {
    private boolean migratedFromRedbackConfiguration = false;
    private List<String> userManagerImpls;
    private List<String> rbacManagerImpls;
    private LdapConfiguration ldapConfiguration;
    private List<LdapGroupMapping> ldapGroupMappings;
    private Map configurationProperties;
    private boolean useUsersCache = true;
    private CacheConfiguration usersCacheConfiguration;

    public void addConfigurationProperty(Object key, String value) {
        this.getConfigurationProperties().put(key, value);
    }

    public void addLdapGroupMapping(LdapGroupMapping ldapGroupMapping) {
        this.getLdapGroupMappings().add(ldapGroupMapping);
    }

    public void addRbacManagerImpl(String string) {
        this.getRbacManagerImpls().add(string);
    }

    public void addUserManagerImpl(String string) {
        this.getUserManagerImpls().add(string);
    }

    public Map getConfigurationProperties() {
        if (this.configurationProperties == null) {
            this.configurationProperties = new HashMap();
        }
        return this.configurationProperties;
    }

    public LdapConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    public List<LdapGroupMapping> getLdapGroupMappings() {
        if (this.ldapGroupMappings == null) {
            this.ldapGroupMappings = new ArrayList<LdapGroupMapping>();
        }
        return this.ldapGroupMappings;
    }

    public List<String> getRbacManagerImpls() {
        if (this.rbacManagerImpls == null) {
            this.rbacManagerImpls = new ArrayList<String>();
        }
        return this.rbacManagerImpls;
    }

    public List<String> getUserManagerImpls() {
        if (this.userManagerImpls == null) {
            this.userManagerImpls = new ArrayList<String>();
        }
        return this.userManagerImpls;
    }

    public CacheConfiguration getUsersCacheConfiguration() {
        return this.usersCacheConfiguration;
    }

    public boolean isMigratedFromRedbackConfiguration() {
        return this.migratedFromRedbackConfiguration;
    }

    public boolean isUseUsersCache() {
        return this.useUsersCache;
    }

    public void removeLdapGroupMapping(LdapGroupMapping ldapGroupMapping) {
        this.getLdapGroupMappings().remove(ldapGroupMapping);
    }

    public void removeRbacManagerImpl(String string) {
        this.getRbacManagerImpls().remove(string);
    }

    public void removeUserManagerImpl(String string) {
        this.getUserManagerImpls().remove(string);
    }

    public void setConfigurationProperties(Map configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setLdapConfiguration(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    public void setLdapGroupMappings(List<LdapGroupMapping> ldapGroupMappings) {
        this.ldapGroupMappings = ldapGroupMappings;
    }

    public void setMigratedFromRedbackConfiguration(boolean migratedFromRedbackConfiguration) {
        this.migratedFromRedbackConfiguration = migratedFromRedbackConfiguration;
    }

    public void setRbacManagerImpls(List<String> rbacManagerImpls) {
        this.rbacManagerImpls = rbacManagerImpls;
    }

    public void setUseUsersCache(boolean useUsersCache) {
        this.useUsersCache = useUsersCache;
    }

    public void setUserManagerImpls(List<String> userManagerImpls) {
        this.userManagerImpls = userManagerImpls;
    }

    public void setUsersCacheConfiguration(CacheConfiguration usersCacheConfiguration) {
        this.usersCacheConfiguration = usersCacheConfiguration;
    }
}

