/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.common.FileTypeUtils;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.FileType;
import org.apache.archiva.configuration.RepositoryScanningConfiguration;
import org.apache.archiva.configuration.functors.FiletypeSelectionPredicate;
import org.apache.archiva.configuration.io.registry.ConfigurationRegistryReader;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryException;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.archiva.redback.components.registry.commons.CommonsConfigurationRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.springframework.stereotype.Service;

@Service(value="fileTypes")
public class FileTypes
implements RegistryListener {
    public static final String ARTIFACTS = "artifacts";
    public static final String AUTO_REMOVE = "auto-remove";
    public static final String INDEXABLE_CONTENT = "indexable-content";
    public static final String IGNORED = "ignored";
    @Inject
    @Named(value="archivaConfiguration#default")
    private ArchivaConfiguration archivaConfiguration;
    private Map<String, List<String>> defaultTypeMap = new HashMap<String, List<String>>();
    private List<String> artifactPatterns;
    public static final List<String> DEFAULT_EXCLUSIONS = FileTypeUtils.DEFAULT_EXCLUSIONS;

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }

    public List<String> getFileTypePatterns(String id) {
        FileType filetype;
        Configuration config = this.archivaConfiguration.getConfiguration();
        FiletypeSelectionPredicate selectedFiletype = new FiletypeSelectionPredicate(id);
        RepositoryScanningConfiguration repositoryScanningConfiguration = config.getRepositoryScanning();
        if (repositoryScanningConfiguration != null && (filetype = (FileType)CollectionUtils.find(config.getRepositoryScanning().getFileTypes(), (Predicate)selectedFiletype)) != null && CollectionUtils.isNotEmpty(filetype.getPatterns())) {
            return filetype.getPatterns();
        }
        List<String> defaultPatterns = this.defaultTypeMap.get(id);
        if (CollectionUtils.isEmpty(defaultPatterns)) {
            return Collections.singletonList("**/*");
        }
        return defaultPatterns;
    }

    public synchronized boolean matchesArtifactPattern(String relativePath) {
        relativePath = relativePath.replace('\\', '/');
        if (this.artifactPatterns == null) {
            this.artifactPatterns = this.getFileTypePatterns(ARTIFACTS);
        }
        for (String pattern : this.artifactPatterns) {
            if (!SelectorUtils.matchPath((String)pattern, (String)relativePath, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesDefaultExclusions(String relativePath) {
        relativePath = relativePath.replace('\\', '/');
        for (String pattern : DEFAULT_EXCLUSIONS) {
            if (!SelectorUtils.matchPath((String)pattern, (String)relativePath, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @PostConstruct
    public void initialize() {
        String errMsg = "Unable to load default archiva configuration for FileTypes: ";
        try {
            CommonsConfigurationRegistry commonsRegistry = new CommonsConfigurationRegistry();
            Field fld = commonsRegistry.getClass().getDeclaredField("configuration");
            fld.setAccessible(true);
            fld.set(commonsRegistry, new CombinedConfiguration());
            commonsRegistry.addConfigurationFromResource("org/apache/archiva/configuration/default-archiva.xml");
            ConfigurationRegistryReader configReader = new ConfigurationRegistryReader();
            Configuration defaultConfig = configReader.read((Registry)commonsRegistry);
            this.initialiseTypeMap(defaultConfig);
        }
        catch (RegistryException e) {
            throw new RuntimeException(errMsg + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(errMsg + e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(errMsg + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(errMsg + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(errMsg + e.getMessage(), e);
        }
        this.archivaConfiguration.addChangeListener(this);
    }

    private void initialiseTypeMap(Configuration configuration) {
        this.defaultTypeMap.clear();
        List<FileType> filetypes = configuration.getRepositoryScanning().getFileTypes();
        for (FileType filetype : filetypes) {
            List<String> patterns = this.defaultTypeMap.get(filetype.getId());
            if (patterns == null) {
                patterns = new ArrayList<String>(filetype.getPatterns().size());
            }
            patterns.addAll(filetype.getPatterns());
            this.defaultTypeMap.put(filetype.getId(), patterns);
        }
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (propertyName.contains("fileType")) {
            this.artifactPatterns = null;
            this.initialiseTypeMap(this.archivaConfiguration.getConfiguration());
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }
}

