/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.util;

import java.util.List;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Strings {
    private Strings() {
    }

    public static String join(List<? extends PropertyInfo> properties) {
        StringBuilder sb = new StringBuilder();
        for (PropertyInfo propertyInfo : properties) {
            sb.append(propertyInfo.getName()).append('.');
        }
        return sb.toString();
    }

    public static String joinMembers(List<? extends PropertyInfo> properties) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo info = properties.get(i);
            if (i > 0) {
                builder.append("/");
            }
            builder.append(Types.toString(info.getMember()));
        }
        return builder.toString();
    }

    public static String joinWithFirstType(List<? extends PropertyInfo> properties) {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (PropertyInfo propertyInfo : properties) {
            sb.append(delim).append(delim.equals("") ? propertyInfo : propertyInfo.getName());
            delim = ".";
        }
        return sb.toString();
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return String.valueOf(chars);
    }
}

