/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.util;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.modelmapper.internal.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Primitives {
    private static Map<Class<?>, Class<?>> primitiveToWrapper = new HashMap();
    private static Map<Class<?>, Class<?>> wrapperToPrimitive;
    private static Map<Class<?>, Object> defaultValue;
    private static Set<String> primitiveWrapperInternalNames;

    private Primitives() {
    }

    public static <T> T defaultValue(Class<?> type) {
        return (T)(type.isPrimitive() ? defaultValue.get(type) : null);
    }

    public static <T> T defaultValueForWrapper(Class<?> wrapper) {
        Class<?> primitiveType = Primitives.primitiveFor(wrapper);
        return (T)(primitiveType == null ? null : defaultValue.get(primitiveType));
    }

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || Primitives.isPrimitiveWrapper(type);
    }

    public static boolean isPrimitiveWrapper(Class<?> type) {
        return wrapperToPrimitive.containsKey(type);
    }

    public static boolean isPrimitiveWrapperInternalName(String name) {
        return primitiveWrapperInternalNames.contains(name);
    }

    public static Class<?> primitiveFor(Class<?> wrapper) {
        return wrapperToPrimitive.get(wrapper);
    }

    public static Class<?> primitiveFor(Type type) {
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 9: {
                return Array.newInstance(Primitives.primitiveFor(type.getElementType()), new int[type.getDimensions()]).getClass();
            }
        }
        return null;
    }

    public static Class<?> wrapperFor(Class<?> type) {
        return type.isPrimitive() ? primitiveToWrapper.get(type) : type;
    }

    static {
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        wrapperToPrimitive = new HashMap();
        wrapperToPrimitive.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitive.put(Character.class, Character.TYPE);
        wrapperToPrimitive.put(Byte.class, Byte.TYPE);
        wrapperToPrimitive.put(Short.class, Short.TYPE);
        wrapperToPrimitive.put(Integer.class, Integer.TYPE);
        wrapperToPrimitive.put(Long.class, Long.TYPE);
        wrapperToPrimitive.put(Float.class, Float.TYPE);
        wrapperToPrimitive.put(Double.class, Double.TYPE);
        defaultValue = new HashMap();
        defaultValue.put(Boolean.TYPE, Boolean.FALSE);
        defaultValue.put(Character.TYPE, Character.valueOf('\u0000'));
        defaultValue.put(Byte.TYPE, (byte)0);
        defaultValue.put(Short.TYPE, (short)0);
        defaultValue.put(Integer.TYPE, 0);
        defaultValue.put(Long.TYPE, 0L);
        defaultValue.put(Float.TYPE, Float.valueOf(0.0f));
        defaultValue.put(Double.TYPE, 0.0);
        primitiveWrapperInternalNames = new HashSet<String>();
        for (Class<?> wrapper : wrapperToPrimitive.keySet()) {
            primitiveWrapperInternalNames.add(wrapper.getName().replace('.', '/'));
        }
    }
}

