/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.util.HashMap;
import java.util.Map;
import org.modelmapper.internal.util.TypeResolver;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.MappingContext;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapConverter
implements ConditionalConverter<Map<?, ?>, Map<Object, Object>> {
    MapConverter() {
    }

    @Override
    public Map<Object, Object> convert(MappingContext<Map<?, ?>, Map<Object, Object>> context) {
        PropertyInfo destInfo;
        Class<?>[] elementTypes;
        Map<?, ?> source = context.getSource();
        if (source == null) {
            return null;
        }
        Map<Object, Object> destination = context.getDestination() == null ? this.createDestination(context) : context.getDestination();
        Mapping mapping = context.getMapping();
        Class<Object> keyElementType = Object.class;
        Class<Object> valueElementType = Object.class;
        if (mapping != null && mapping instanceof PropertyMapping && (elementTypes = TypeResolver.resolveArguments((destInfo = ((PropertyMapping)mapping).getLastDestinationProperty()).getGenericType(), destInfo.getMember().getDeclaringClass())) != null) {
            keyElementType = elementTypes[0] == TypeResolver.Unknown.class ? Object.class : elementTypes[0];
            valueElementType = elementTypes[1] == TypeResolver.Unknown.class ? Object.class : elementTypes[1];
        }
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            Object key = null;
            if (entry.getKey() != null) {
                MappingContext<?, Object> keyContext = context.create(entry.getKey(), keyElementType);
                key = context.getMappingEngine().map(keyContext);
            }
            Object value = null;
            if (entry.getValue() != null) {
                MappingContext<?, Object> valueContext = context.create(entry.getValue(), valueElementType);
                value = context.getMappingEngine().map(valueContext);
            }
            destination.put(key, value);
        }
        return destination;
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Map.class.isAssignableFrom(sourceType) && Map.class.isAssignableFrom(destinationType) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    protected Map<Object, Object> createDestination(MappingContext<Map<?, ?>, Map<Object, Object>> context) {
        if (context.getDestinationType().isInterface()) {
            return new HashMap<Object, Object>();
        }
        return context.getMappingEngine().createDestination(context);
    }
}

