/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.modelmapper.internal.converter.ArrayConverter;
import org.modelmapper.internal.converter.AssignableConverter;
import org.modelmapper.internal.converter.BooleanConverter;
import org.modelmapper.internal.converter.CalendarConverter;
import org.modelmapper.internal.converter.CharacterConverter;
import org.modelmapper.internal.converter.CollectionConverter;
import org.modelmapper.internal.converter.DateConverter;
import org.modelmapper.internal.converter.EnumConverter;
import org.modelmapper.internal.converter.MapConverter;
import org.modelmapper.internal.converter.NumberConverter;
import org.modelmapper.internal.converter.StringConverter;
import org.modelmapper.spi.ConditionalConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConverterStore {
    private static final ConditionalConverter<?, ?>[] DEFAULT_CONVERTERS = new ConditionalConverter[]{new ArrayConverter(), new CollectionConverter(), new MapConverter(), new AssignableConverter(), new StringConverter(), new EnumConverter(), new NumberConverter(), new BooleanConverter(), new CharacterConverter(), new DateConverter(), new CalendarConverter()};
    private final List<ConditionalConverter<?, ?>> converters = new CopyOnWriteArrayList();

    public ConverterStore() {
        for (ConditionalConverter<?, ?> converter : DEFAULT_CONVERTERS) {
            this.converters.add(converter);
        }
    }

    public <S, D> ConditionalConverter<S, D> getFirstSupported(Class<?> sourceType, Class<?> destinationType) {
        for (ConditionalConverter<?, ?> converter : this.converters) {
            if (ConditionalConverter.MatchResult.NONE.equals((Object)converter.match(sourceType, destinationType))) continue;
            return converter;
        }
        return null;
    }

    public List<ConditionalConverter<?, ?>> getConverters() {
        return this.converters;
    }
}

