/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import org.modelmapper.internal.Errors;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BooleanConverter
implements ConditionalConverter<Object, Boolean> {
    private static final String[] TRUE_STRINGS = new String[]{"true", "yes", "y", "on", "1"};
    private static final String[] FALSE_STRINGSS = new String[]{"false", "no", "n", "off", "0"};

    BooleanConverter() {
    }

    @Override
    public Boolean convert(MappingContext<Object, Boolean> context) {
        int i;
        Object source = context.getSource();
        if (source == null) {
            return null;
        }
        String stringValue = source.toString().toLowerCase();
        for (i = 0; i < TRUE_STRINGS.length; ++i) {
            if (!TRUE_STRINGS[i].equals(stringValue)) continue;
            return Boolean.TRUE;
        }
        for (i = 0; i < FALSE_STRINGSS.length; ++i) {
            if (!FALSE_STRINGSS[i].equals(stringValue)) continue;
            return Boolean.FALSE;
        }
        throw new Errors().errorMapping(context.getSource(), context.getDestinationType()).toMappingException();
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        boolean destMatch;
        boolean bl = destMatch = destinationType == Boolean.class || destinationType == Boolean.TYPE;
        return destMatch ? (sourceType == Boolean.class || sourceType == Boolean.TYPE ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.PARTIAL) : ConditionalConverter.MatchResult.NONE;
    }
}

