/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.modelmapper.Condition;
import org.modelmapper.Converter;
import org.modelmapper.PropertyMap;
import org.modelmapper.Provider;
import org.modelmapper.TypeMap;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.ExplicitMappingBuilder;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.MappingContextImpl;
import org.modelmapper.internal.MappingEngineImpl;
import org.modelmapper.internal.MappingImpl;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.TypeInfoImpl;
import org.modelmapper.internal.TypeInfoRegistry;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeMapImpl<S, D>
implements TypeMap<S, D> {
    private final Class<S> sourceType;
    private final Class<D> destinationType;
    private final String name;
    final InheritingConfiguration configuration;
    private final MappingEngineImpl engine;
    private final Map<String, PropertyInfo> mappedProperties = new HashMap<String, PropertyInfo>();
    private final Map<String, MappingImpl> mappings = new TreeMap<String, MappingImpl>();
    private Converter<S, D> converter;
    private Converter<S, D> preConverter;
    private Converter<S, D> postConverter;
    private Condition<?, ?> condition;
    private Provider<D> provider;
    private Converter<?, ?> propertyConverter;
    private Condition<?, ?> propertyCondition;
    private Provider<?> propertyProvider;

    TypeMapImpl(Class<S> sourceType, Class<D> destinationType, String name, InheritingConfiguration configuration, MappingEngineImpl engine) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
        this.name = name;
        this.configuration = configuration;
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMappings(PropertyMap<S, D> propertyMap) {
        if (this.sourceType.isEnum() || this.destinationType.isEnum()) {
            throw new Errors().mappingForEnum().toConfigurationException();
        }
        Map<String, MappingImpl> map = this.mappings;
        synchronized (map) {
            for (MappingImpl mapping : new ExplicitMappingBuilder<S, D>(this.sourceType, this.destinationType, this.configuration).build(propertyMap)) {
                MappingImpl existingMapping = this.addMapping(mapping);
                if (existingMapping == null || !existingMapping.isExplicit()) continue;
                throw new Errors().duplicateMapping(mapping.getLastDestinationProperty()).toConfigurationException();
            }
        }
    }

    @Override
    public Condition<?, ?> getCondition() {
        return this.condition;
    }

    @Override
    public Converter<S, D> getConverter() {
        return this.converter;
    }

    @Override
    public Class<D> getDestinationType() {
        return this.destinationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Mapping> getMappings() {
        Map<String, MappingImpl> map = this.mappings;
        synchronized (map) {
            return new ArrayList<Mapping>(this.mappings.values());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Converter<S, D> getPostConverter() {
        return this.postConverter;
    }

    @Override
    public Converter<S, D> getPreConverter() {
        return this.preConverter;
    }

    @Override
    public Condition<?, ?> getPropertyCondition() {
        return this.propertyCondition;
    }

    @Override
    public Converter<?, ?> getPropertyConverter() {
        return this.propertyConverter;
    }

    @Override
    public Provider<?> getPropertyProvider() {
        return this.propertyProvider;
    }

    @Override
    public Provider<D> getProvider() {
        return this.provider;
    }

    @Override
    public Class<S> getSourceType() {
        return this.sourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyInfo> getUnmappedProperties() {
        TypeInfoImpl<D> destinationInfo = TypeInfoRegistry.typeInfoFor(this.destinationType, this.configuration);
        ArrayList<PropertyInfo> unmapped = new ArrayList<PropertyInfo>();
        Map<String, MappingImpl> map = this.mappings;
        synchronized (map) {
            for (Map.Entry<String, Mutator> entry : destinationInfo.getMutators().entrySet()) {
                if (this.mappedProperties.containsKey(entry.getKey())) continue;
                unmapped.add(entry.getValue());
            }
        }
        return unmapped;
    }

    @Override
    public D map(S source) {
        Class sourceType = Types.deProxy(source.getClass());
        MappingContextImpl<S, Object> context = new MappingContextImpl<S, Object>(source, sourceType, null, this.destinationType, null, this.name, this.engine);
        D result = null;
        try {
            result = this.engine.typeMap(context, this);
        }
        catch (Throwable t) {
            context.errors.errorMapping(sourceType, this.destinationType, t);
        }
        context.errors.throwMappingExceptionIfErrorsExist();
        return result;
    }

    @Override
    public void map(S source, D destination) {
        Class sourceType = Types.deProxy(source.getClass());
        MappingContextImpl<S, D> context = new MappingContextImpl<S, D>(source, sourceType, destination, this.destinationType, null, this.name, this.engine);
        try {
            this.engine.typeMap(context, this);
        }
        catch (Throwable t) {
            context.errors.errorMapping(sourceType, this.destinationType, t);
        }
        context.errors.throwMappingExceptionIfErrorsExist();
    }

    @Override
    public TypeMap<S, D> setCondition(Condition<?, ?> condition) {
        this.condition = Assert.notNull(condition, "condition");
        return this;
    }

    @Override
    public TypeMap<S, D> setConverter(Converter<S, D> converter) {
        this.converter = Assert.notNull(converter, "converter");
        return this;
    }

    @Override
    public TypeMap<S, D> setPostConverter(Converter<S, D> converter) {
        this.postConverter = Assert.notNull(converter, "converter");
        return this;
    }

    @Override
    public TypeMap<S, D> setPreConverter(Converter<S, D> converter) {
        this.preConverter = Assert.notNull(converter, "converter");
        return this;
    }

    @Override
    public TypeMap<S, D> setPropertyCondition(Condition<?, ?> condition) {
        this.propertyCondition = Assert.notNull(condition, "condition");
        return this;
    }

    @Override
    public TypeMap<S, D> setPropertyConverter(Converter<?, ?> converter) {
        this.propertyConverter = Assert.notNull(converter, "converter");
        return this;
    }

    @Override
    public TypeMap<S, D> setPropertyProvider(Provider<?> provider) {
        this.propertyProvider = Assert.notNull(provider, "provider");
        return this;
    }

    @Override
    public TypeMap<S, D> setProvider(Provider<D> provider) {
        this.provider = Assert.notNull(provider, "provider");
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TypeMap[").append(this.sourceType.getSimpleName()).append(" -> ").append(this.destinationType.getSimpleName());
        if (this.name != null) {
            b.append(' ').append(this.name);
        }
        return b.append(']').toString();
    }

    @Override
    public void validate() {
        if (this.converter != null || this.preConverter != null || this.postConverter != null) {
            return;
        }
        Errors errors = new Errors();
        List<PropertyInfo> unmappedProperties = this.getUnmappedProperties();
        if (!unmappedProperties.isEmpty()) {
            errors.errorUnmappedProperties(this, unmappedProperties);
        }
        errors.throwValidationExceptionIfErrorsExist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MappingImpl addMapping(MappingImpl mapping) {
        Map<String, MappingImpl> map = this.mappings;
        synchronized (map) {
            this.mappedProperties.put(mapping.getDestinationProperties().get(0).getName(), mapping.getDestinationProperties().get(0));
            return this.mappings.put(mapping.getPath(), mapping);
        }
    }

    boolean isSkipped(String path) {
        Mapping mapping = this.mappings.get(path);
        return mapping != null && mapping.isSkipped();
    }

    MappingImpl mappingFor(String path) {
        return this.mappings.get(path);
    }
}

