/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.ErrorsException;
import org.modelmapper.internal.cglib.core.DefaultNamingPolicy;
import org.modelmapper.internal.cglib.core.NamingPolicy;
import org.modelmapper.internal.cglib.proxy.CallbackFilter;
import org.modelmapper.internal.cglib.proxy.Enhancer;
import org.modelmapper.internal.cglib.proxy.MethodInterceptor;
import org.modelmapper.internal.cglib.proxy.NoOp;
import org.modelmapper.internal.objenesis.Objenesis;
import org.modelmapper.internal.objenesis.ObjenesisStd;
import org.modelmapper.internal.util.Primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProxyFactory {
    private static final Objenesis OBJENESIS = new ObjenesisStd();
    private static final NamingPolicy NAMING_POLICY = new DefaultNamingPolicy(){

        protected String getTag() {
            return "ByModelMapper";
        }
    };
    private static final CallbackFilter METHOD_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            return method.isBridge() || method.getDeclaringClass().equals(Object.class) || method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(Object.class) && method.getReturnType().equals(Boolean.TYPE) || method.getReturnType().getName().equals("groovy.lang.MetaClass") && (method.getName().equals("getMetaClass") || method.getName().startsWith("$")) ? 1 : 0;
        }
    };

    ProxyFactory() {
    }

    static Class<?> proxyClassFor(Class<?> type, Errors errors) throws ErrorsException {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setUseFactory(true);
        enhancer.setUseCache(true);
        enhancer.setNamingPolicy(NAMING_POLICY);
        enhancer.setCallbackFilter(METHOD_FILTER);
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
        try {
            return enhancer.createClass();
        }
        catch (Throwable t) {
            throw errors.errorEnhancingClass(type, t).toException();
        }
    }

    static <T> T proxyFor(Class<T> type, MethodInterceptor interceptor, Errors errors) throws ErrorsException {
        if (Modifier.isFinal(type.getModifiers())) {
            return Primitives.defaultValueForWrapper(type);
        }
        Class<?> enhanced = ProxyFactory.proxyClassFor(type, errors);
        try {
            Object result = OBJENESIS.newInstance(enhanced);
            ProxyFactory.setCallbacks(result, interceptor);
            return (T)result;
        }
        catch (Throwable t) {
            throw errors.errorInstantiatingProxy(type, t).toException();
        }
    }

    private static void setCallbacks(Object enhanced, MethodInterceptor interceptor) throws Exception {
        Field callback1 = enhanced.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        callback1.setAccessible(true);
        callback1.set(enhanced, interceptor);
        Field callback2 = enhanced.getClass().getDeclaredField("CGLIB$CALLBACK_1");
        callback2.setAccessible(true);
        callback2.set(enhanced, NoOp.INSTANCE);
    }
}

