/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.ArrayList;
import java.util.List;
import org.modelmapper.Condition;
import org.modelmapper.Converter;
import org.modelmapper.Provider;
import org.modelmapper.internal.ExplicitMappingBuilder;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.util.Strings;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MappingImpl
implements Mapping,
Comparable<MappingImpl> {
    protected final List<PropertyInfo> destinationMutators;
    private final boolean explicit;
    private final String path;
    private boolean skip;
    private Condition<?, ?> condition;
    protected Provider<?> provider;
    protected Converter<?, ?> converter;

    MappingImpl(List<? extends PropertyInfo> destinationMutators) {
        this.destinationMutators = new ArrayList<PropertyInfo>(destinationMutators);
        this.path = Strings.join(destinationMutators);
        this.explicit = false;
    }

    MappingImpl(List<Mutator> destinationMutators, ExplicitMappingBuilder.MappingOptions options) {
        this.destinationMutators = new ArrayList<Mutator>(destinationMutators);
        this.path = Strings.join(destinationMutators);
        this.skip = options.skipType != 0;
        this.condition = options.condition;
        this.provider = options.provider;
        this.converter = options.converter;
        this.explicit = true;
    }

    MappingImpl(MappingImpl copy, List<? extends PropertyInfo> mergedMutators) {
        this.destinationMutators = new ArrayList<PropertyInfo>(copy.destinationMutators.size() + (mergedMutators == null ? 0 : mergedMutators.size()));
        this.destinationMutators.addAll(mergedMutators);
        this.destinationMutators.addAll(copy.destinationMutators);
        this.path = Strings.join(this.destinationMutators);
        this.skip = copy.skip;
        this.condition = copy.condition;
        this.provider = copy.provider;
        this.converter = copy.converter;
        this.explicit = copy.explicit;
    }

    @Override
    public int compareTo(MappingImpl mapping) {
        return this.path.compareToIgnoreCase(mapping.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MappingImpl)) {
            return false;
        }
        MappingImpl other = (MappingImpl)obj;
        return this.path.equals(other.path);
    }

    @Override
    public Condition<?, ?> getCondition() {
        return this.condition;
    }

    @Override
    public Converter<?, ?> getConverter() {
        return this.converter;
    }

    @Override
    public List<? extends PropertyInfo> getDestinationProperties() {
        return this.destinationMutators;
    }

    @Override
    public PropertyInfo getLastDestinationProperty() {
        return this.destinationMutators.get(this.destinationMutators.size() - 1);
    }

    @Override
    public Provider<?> getProvider() {
        return this.provider;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public boolean isSkipped() {
        return this.skip;
    }

    abstract MappingImpl createMergedCopy(List<? extends PropertyInfo> var1, List<? extends PropertyInfo> var2);

    String getPath() {
        return this.path;
    }

    boolean isExplicit() {
        return this.explicit;
    }
}

