/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.convention;

import java.util.List;
import org.modelmapper.convention.InexactMatcher;
import org.modelmapper.spi.MatchingStrategy;

final class StandardMatchingStrategy
implements MatchingStrategy {
    StandardMatchingStrategy() {
    }

    public boolean matches(MatchingStrategy.PropertyNameInfo propertyNameInfo) {
        return new Matcher(propertyNameInfo).match();
    }

    public boolean isExact() {
        return false;
    }

    public String toString() {
        return "Standard";
    }

    static class Matcher
    extends InexactMatcher {
        private final boolean[] sourceMatches;

        Matcher(MatchingStrategy.PropertyNameInfo propertyNameInfo) {
            super(propertyNameInfo);
            this.sourceMatches = new boolean[this.sourceTokens.size()];
        }

        boolean match() {
            List<String[]> destTokens = this.propertyNameInfo.getDestinationPropertyTokens();
            for (int destIndex = 0; destIndex < destTokens.size(); ++destIndex) {
                String[] tokens = destTokens.get(destIndex);
                int destTokenIndex = 0;
                while (destTokenIndex < tokens.length) {
                    int matchedTokens = this.matchSourcePropertyName(tokens, destTokenIndex);
                    if (matchedTokens == 0) {
                        if (this.matchSourcePropertyType(tokens[destTokenIndex]) || this.matchSourceClass(tokens[destTokenIndex])) {
                            ++destTokenIndex;
                            continue;
                        }
                        return false;
                    }
                    destTokenIndex += matchedTokens;
                }
            }
            for (int i = 0; i < this.sourceMatches.length; ++i) {
                if (this.sourceMatches[i] || this.matchedPreviously(i)) continue;
                return false;
            }
            return true;
        }

        int matchSourcePropertyName(String[] destTokens, int destStartIndex) {
            for (int sourceIndex = 0; sourceIndex < this.sourceTokens.size(); ++sourceIndex) {
                String[] srcTokens = (String[])this.sourceTokens.get(sourceIndex);
                int matched = Matcher.matchTokens(srcTokens, destTokens, destStartIndex);
                if (matched <= 0) continue;
                this.sourceMatches[sourceIndex] = true;
                return matched;
            }
            return 0;
        }

        boolean matchedPreviously(int index) {
            for (int sourceIndex = 0; sourceIndex < index; ++sourceIndex) {
                if (!this.sourceMatches[sourceIndex]) continue;
                String[] current = (String[])this.sourceTokens.get(index);
                String[] previous = (String[])this.sourceTokens.get(sourceIndex);
                for (int i = 0; i < current.length; ++i) {
                    for (int j = 0; j < previous.length; ++j) {
                        if (!current[i].equalsIgnoreCase(previous[j])) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

