/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.convention;

import java.util.List;
import org.modelmapper.spi.MatchingStrategy;

class InexactMatcher {
    protected final MatchingStrategy.PropertyNameInfo propertyNameInfo;
    protected final List<String[]> sourceTokens;

    InexactMatcher(MatchingStrategy.PropertyNameInfo propertyNameInfo) {
        this.propertyNameInfo = propertyNameInfo;
        this.sourceTokens = propertyNameInfo.getSourcePropertyTokens();
    }

    static int matchTokens(String[] src, String[] dst, int dstStartIndex) {
        block0: for (int srcStartIndex = 0; srcStartIndex < src.length; ++srcStartIndex) {
            String srcStr = src[srcStartIndex];
            String dstStr = dst[dstStartIndex];
            int srcIndex = srcStartIndex;
            int dstIndex = dstStartIndex;
            int srcCharIndex = 0;
            int dstCharIndex = 0;
            while (true) {
                char c1 = srcStr.charAt(srcCharIndex);
                char c2 = dstStr.charAt(dstCharIndex);
                if (Character.toUpperCase(c1) != Character.toUpperCase(c2) || Character.toLowerCase(c1) != Character.toLowerCase(c2)) continue block0;
                if (dstCharIndex == dstStr.length() - 1) {
                    if (srcCharIndex == srcStr.length() - 1) {
                        return dstIndex - dstStartIndex + 1;
                    }
                    if (dstIndex == dst.length - 1) {
                        return 0;
                    }
                    dstStr = dst[++dstIndex];
                    dstCharIndex = 0;
                } else {
                    ++dstCharIndex;
                }
                if (srcCharIndex == srcStr.length() - 1) {
                    if (srcIndex == src.length - 1) {
                        return 0;
                    }
                    srcStr = src[++srcIndex];
                    srcCharIndex = 0;
                    continue;
                }
                ++srcCharIndex;
            }
        }
        return 0;
    }

    boolean matchSourceClass(String destination) {
        String[] tokens = this.propertyNameInfo.getSourceClassTokens();
        for (int tokenIndex = 0; tokenIndex < tokens.length; ++tokenIndex) {
            if (!tokens[tokenIndex].equalsIgnoreCase(destination)) continue;
            return true;
        }
        return false;
    }

    boolean matchSourcePropertyType(String destination) {
        for (int sourceIndex = 0; sourceIndex < this.sourceTokens.size(); ++sourceIndex) {
            String[] tokens = this.propertyNameInfo.getSourcePropertyTypeTokens().get(sourceIndex);
            for (int tokenIndex = 0; tokenIndex < tokens.length; ++tokenIndex) {
                if (!tokens[tokenIndex].equalsIgnoreCase(destination)) continue;
                return true;
            }
        }
        return false;
    }
}

