/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper;

import java.lang.reflect.Type;
import java.util.Collection;
import org.modelmapper.Converter;
import org.modelmapper.PropertyMap;
import org.modelmapper.TypeMap;
import org.modelmapper.TypeToken;
import org.modelmapper.ValidationException;
import org.modelmapper.config.Configuration;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.MappingEngineImpl;
import org.modelmapper.internal.util.Assert;
import org.modelmapper.internal.util.TypeResolver;
import org.modelmapper.internal.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMapper {
    private final InheritingConfiguration config = new InheritingConfiguration();
    private final MappingEngineImpl engine = new MappingEngineImpl(this.config);

    public <S, D> void addConverter(Converter<S, D> converter) {
        Assert.notNull(converter, "converter");
        Class<?>[] typeArguments = TypeResolver.resolveArguments(converter.getClass(), Converter.class);
        Assert.notNull("Must declare source type argument <S> and destination type argument <D> for converter");
        this.config.typeMapStore.getOrCreate(null, typeArguments[0], typeArguments[1], null, null, converter, this.engine);
    }

    public <S, D> TypeMap<S, D> addMappings(PropertyMap<S, D> propertyMap) {
        Assert.notNull(propertyMap, "propertyMap");
        return this.config.typeMapStore.getOrCreate(null, propertyMap.sourceType, propertyMap.destinationType, null, propertyMap, null, this.engine);
    }

    public <S, D> TypeMap<S, D> createTypeMap(Class<S> sourceType, Class<D> destinationType) {
        return this.createTypeMap((S)sourceType, destinationType, (Configuration)this.config);
    }

    public <S, D> TypeMap<S, D> createTypeMap(Class<S> sourceType, Class<D> destinationType, Configuration configuration) {
        Assert.notNull(sourceType, "sourceType");
        Assert.notNull(destinationType, "destinationType");
        Assert.notNull(configuration, "configuration");
        return this.createTypeMapInternal(null, sourceType, destinationType, null, configuration);
    }

    public <S, D> TypeMap<S, D> createTypeMap(Class<S> sourceType, Class<D> destinationType, String typeMapName) {
        return this.createTypeMap((S)sourceType, destinationType, typeMapName, (Configuration)this.config);
    }

    public <S, D> TypeMap<S, D> createTypeMap(Class<S> sourceType, Class<D> destinationType, String typeMapName, Configuration configuration) {
        Assert.notNull(sourceType, "sourceType");
        Assert.notNull(destinationType, "destinationType");
        Assert.notNull(typeMapName, "typeMapName");
        Assert.notNull(configuration, "configuration");
        return this.createTypeMapInternal(null, sourceType, destinationType, typeMapName, configuration);
    }

    public <S, D> TypeMap<S, D> createTypeMap(S source, Class<D> destinationType) {
        return this.createTypeMap(source, destinationType, (Configuration)this.config);
    }

    public <S, D> TypeMap<S, D> createTypeMap(S source, Class<D> destinationType, Configuration configuration) {
        Assert.notNull(source, "source");
        Assert.notNull(destinationType, "destinationType");
        Assert.notNull(configuration, "configuration");
        return this.createTypeMapInternal(source, null, destinationType, null, configuration);
    }

    public <S, D> TypeMap<S, D> createTypeMap(S source, Class<D> destinationType, String typeMapName) {
        return this.createTypeMap(source, destinationType, typeMapName, (Configuration)this.config);
    }

    public <S, D> TypeMap<S, D> createTypeMap(S source, Class<D> destinationType, String typeMapName, Configuration configuration) {
        Assert.notNull(source, "source");
        Assert.notNull(destinationType, "destinationType");
        Assert.notNull(typeMapName, "typeMapName");
        Assert.notNull(configuration, "configuration");
        return this.createTypeMapInternal(source, null, destinationType, typeMapName, configuration);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public <S, D> TypeMap<S, D> getTypeMap(Class<S> sourceType, Class<D> destinationType) {
        Assert.notNull(sourceType, "sourceType");
        Assert.notNull(destinationType, "destinationType");
        return this.config.typeMapStore.get(sourceType, destinationType, null);
    }

    public <S, D> TypeMap<S, D> getTypeMap(Class<S> sourceType, Class<D> destinationType, String typeMapName) {
        Assert.notNull(sourceType, "sourceType");
        Assert.notNull(destinationType, "destinationType");
        Assert.notNull(typeMapName, "typeMapName");
        return this.config.typeMapStore.get(sourceType, destinationType, typeMapName);
    }

    public Collection<TypeMap<?, ?>> getTypeMaps() {
        return this.config.typeMapStore.get();
    }

    public <D> D map(Object source, Class<D> destinationType) {
        Assert.notNull(source, "source");
        Assert.notNull(destinationType, "destinationType");
        return this.mapInternal(source, null, destinationType, null);
    }

    public <D> D map(Object source, Class<D> destinationType, String typeMapName) {
        Assert.notNull(source, "source");
        Assert.notNull(destinationType, "destinationType");
        Assert.notNull(typeMapName, "typeMapName");
        return this.mapInternal(source, null, destinationType, typeMapName);
    }

    public void map(Object source, Object destination) {
        Assert.notNull(source, "source");
        Assert.notNull(destination, "destination");
        this.mapInternal(source, destination, null, null);
    }

    public void map(Object source, Object destination, String typeMapName) {
        Assert.notNull(source, "source");
        Assert.notNull(destination, "destination");
        Assert.notNull(typeMapName, "typeMapName");
        this.mapInternal(source, destination, null, typeMapName);
    }

    public <D> D map(Object source, Type destinationType) {
        Assert.notNull(source, "source");
        Assert.notNull(destinationType, "destinationType");
        return this.mapInternal(source, null, destinationType, null);
    }

    public <D> D map(Object source, Type destinationType, String typeMapName) {
        Assert.notNull(source, "source");
        Assert.notNull(destinationType, "destinationType");
        Assert.notNull(typeMapName, "typeMapName");
        return this.mapInternal(source, null, destinationType, typeMapName);
    }

    public void validate() {
        Errors errors = new Errors();
        for (TypeMap<?, ?> typeMap : this.getTypeMaps()) {
            try {
                typeMap.validate();
            }
            catch (ValidationException e) {
                errors.merge(e.getErrorMessages());
            }
        }
        errors.throwValidationExceptionIfErrorsExist();
    }

    private <S, D> TypeMap<S, D> createTypeMapInternal(S source, Class<S> sourceType, Class<D> destinationType, String typeMapName, Configuration configuration) {
        if (source != null) {
            sourceType = Types.deProxy(source.getClass());
        }
        Assert.state(this.config.typeMapStore.get(sourceType, destinationType, typeMapName) == null, String.format("A TypeMap already exists for %s and %s", sourceType, destinationType), new Object[0]);
        return this.config.typeMapStore.create(source, sourceType, destinationType, typeMapName, (InheritingConfiguration)configuration, this.engine);
    }

    private <D> D mapInternal(Object source, D destination, Type destinationType, String typeMapName) {
        if (destination != null) {
            destinationType = Types.deProxy(destination.getClass());
        }
        return this.engine.map(source, Types.deProxy(source.getClass()), destination, TypeToken.of(destinationType), typeMapName);
    }
}

