/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.registry.commons;

import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;

public class ConfigurationListenerDelegate
implements ConfigurationListener {
    private RegistryListener listener;
    private Registry registry;

    public ConfigurationListenerDelegate(RegistryListener listener, Registry registry) {
        this.listener = listener;
        this.registry = registry;
    }

    public void configurationChanged(ConfigurationEvent event) {
        if (event.getPropertyName() != null) {
            if (event.isBeforeUpdate()) {
                this.listener.beforeConfigurationChange(this.registry, event.getPropertyName(), event.getPropertyValue());
            } else {
                this.listener.afterConfigurationChange(this.registry, event.getPropertyName(), event.getPropertyValue());
            }
        }
    }

    public int hashCode() {
        return this.listener.hashCode();
    }

    public boolean equals(Object obj) {
        if (ConfigurationListenerDelegate.class.isAssignableFrom(obj.getClass())) {
            ConfigurationListenerDelegate delegate = (ConfigurationListenerDelegate)ConfigurationListenerDelegate.class.cast(obj);
            return delegate.listener == this.listener;
        }
        return super.equals(obj);
    }
}

