/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.components.registry.commons;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryException;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.archiva.redback.components.registry.commons.ConfigurationListenerDelegate;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.event.EventSource;
import org.apache.commons.configuration.tree.DefaultExpressionEngine;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="commons-configuration")
public class CommonsConfigurationRegistry
implements Registry {
    private Configuration configuration;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String propertyDelimiter = ".";
    private String properties;

    public CommonsConfigurationRegistry() {
        this.logger.debug("empty constructor");
    }

    public CommonsConfigurationRegistry(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration can not be null");
        }
        this.configuration = configuration;
    }

    public String dump() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Configuration Dump.");
        Iterator i = this.configuration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = this.configuration.getProperty(key);
            buffer.append("\n\"").append(key).append("\" = \"").append(value).append("\"");
        }
        return buffer.toString();
    }

    public boolean isEmpty() {
        return this.configuration.isEmpty();
    }

    public Registry getSubset(String key) {
        return new CommonsConfigurationRegistry(this.configuration.subset(key));
    }

    public List getList(String key) {
        return this.configuration.getList(key);
    }

    public List<Registry> getSubsetList(String key) {
        ArrayList<Registry> subsets = new ArrayList<Registry>();
        boolean done = false;
        do {
            Registry registry;
            if (!(registry = this.getSubset(key + "(" + subsets.size() + ")")).isEmpty()) {
                subsets.add(registry);
                continue;
            }
            done = true;
        } while (!done);
        return subsets;
    }

    public Properties getProperties(String key) {
        Configuration configuration = this.configuration.subset(key);
        Properties properties = new Properties();
        Iterator i = configuration.getKeys();
        while (i.hasNext()) {
            String property = (String)i.next();
            List l = configuration.getList(property);
            StringBuilder sb = new StringBuilder();
            for (Object element : l) {
                sb.append((String)element);
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            properties.setProperty(property, sb.toString());
        }
        return properties;
    }

    public void save() throws RegistryException {
        if (this.configuration instanceof FileConfiguration) {
            FileConfiguration fileConfiguration = (FileConfiguration)this.configuration;
            try {
                fileConfiguration.save();
            }
            catch (ConfigurationException e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new RegistryException("Can only save file-based configurations");
        }
    }

    public void addChangeListener(RegistryListener listener) {
        EventSource eventSource = (EventSource)EventSource.class.cast(this.configuration);
        eventSource.addConfigurationListener((ConfigurationListener)new ConfigurationListenerDelegate(listener, this));
    }

    public boolean removeChangeListener(RegistryListener listener) {
        EventSource eventSource = (EventSource)EventSource.class.cast(this.configuration);
        boolean removed = eventSource.removeConfigurationListener((ConfigurationListener)new ConfigurationListenerDelegate(listener, this));
        return removed;
    }

    public int getChangeListenersSize() {
        return ((EventSource)EventSource.class.cast(this.configuration)).getConfigurationListeners().size();
    }

    public Collection<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        Iterator i = this.configuration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            int index = key.indexOf(46);
            if (index < 0) {
                keys.add(key);
                continue;
            }
            keys.add(key.substring(0, index));
        }
        return keys;
    }

    public Collection getFullKeys() {
        HashSet keys = new HashSet();
        Iterator i = this.configuration.getKeys();
        while (i.hasNext()) {
            keys.add(i.next());
        }
        return keys;
    }

    public void remove(String key) {
        this.configuration.clearProperty(key);
    }

    public void removeSubset(String key) {
        ArrayList keys = new ArrayList();
        Iterator i = this.configuration.getKeys(key);
        while (i.hasNext()) {
            keys.add(i.next());
        }
        i = keys.iterator();
        while (i.hasNext()) {
            this.configuration.clearProperty((String)i.next());
        }
    }

    public String getString(String key) {
        return this.configuration.getString(key);
    }

    public String getString(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    public void setString(String key, String value) {
        this.configuration.setProperty(key, (Object)value);
    }

    public int getInt(String key) {
        return this.configuration.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.configuration.getInt(key, defaultValue);
    }

    public void setInt(String key, int value) {
        this.configuration.setProperty(key, (Object)value);
    }

    public boolean getBoolean(String key) {
        return this.configuration.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.configuration.getBoolean(key, defaultValue);
    }

    public void setBoolean(String key, boolean value) {
        this.configuration.setProperty(key, (Object)value);
    }

    public void addConfigurationFromResource(String resource) throws RegistryException {
        this.addConfigurationFromResource(resource, null);
    }

    public void addConfigurationFromResource(String resource, String prefix) throws RegistryException {
        CombinedConfiguration configuration = (CombinedConfiguration)this.configuration;
        if (resource.endsWith(".properties")) {
            try {
                this.logger.debug("Loading properties configuration from classloader resource: {}", (Object)resource);
                configuration.addConfiguration((AbstractConfiguration)new PropertiesConfiguration(resource), null, prefix);
            }
            catch (ConfigurationException e) {
                throw new RegistryException("Unable to add configuration from resource '" + resource + "': " + e.getMessage(), (Throwable)e);
            }
        } else if (resource.endsWith(".xml")) {
            try {
                this.logger.debug("Loading XML configuration from classloader resource: {}", (Object)resource);
                configuration.addConfiguration((AbstractConfiguration)new XMLConfiguration(resource), null, prefix);
            }
            catch (ConfigurationException e) {
                throw new RegistryException("Unable to add configuration from resource '" + resource + "': " + e.getMessage(), (Throwable)e);
            }
        } else {
            throw new RegistryException("Unable to add configuration from resource '" + resource + "': unrecognised type");
        }
    }

    public void addConfigurationFromFile(File file) throws RegistryException {
        this.addConfigurationFromFile(file, null);
    }

    public void addConfigurationFromFile(File file, String prefix) throws RegistryException {
        CombinedConfiguration configuration = (CombinedConfiguration)this.configuration;
        if (file.getName().endsWith(".properties")) {
            try {
                this.logger.debug("Loading properties configuration from file: {}", (Object)file);
                configuration.addConfiguration((AbstractConfiguration)new PropertiesConfiguration(file), null, prefix);
            }
            catch (ConfigurationException e) {
                throw new RegistryException("Unable to add configuration from file '" + file.getName() + "': " + e.getMessage(), (Throwable)e);
            }
        } else if (file.getName().endsWith(".xml")) {
            try {
                this.logger.debug("Loading XML configuration from file: {}", (Object)file);
                configuration.addConfiguration((AbstractConfiguration)new XMLConfiguration(file), null, prefix);
            }
            catch (ConfigurationException e) {
                throw new RegistryException("Unable to add configuration from file '" + file.getName() + "': " + e.getMessage(), (Throwable)e);
            }
        } else {
            throw new RegistryException("Unable to add configuration from file '" + file.getName() + "': unrecognised type");
        }
    }

    @PostConstruct
    public void initialize() throws RegistryException {
        try {
            CombinedConfiguration configuration;
            if (StringUtils.isNotBlank((String)this.properties)) {
                try {
                    DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                    DefaultExpressionEngine expressionEngine = new DefaultExpressionEngine();
                    expressionEngine.setPropertyDelimiter(this.propertyDelimiter);
                    builder.setExpressionEngine((ExpressionEngine)expressionEngine);
                    StringSearchInterpolator interpolator = new StringSearchInterpolator("${", "}");
                    interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
                    String interpolatedProps = interpolator.interpolate(this.properties);
                    this.logger.debug("Loading configuration into commons-configuration, xml {}", (Object)interpolatedProps);
                    builder.load((Reader)new StringReader(interpolatedProps));
                    configuration = builder.getConfiguration(false);
                    configuration.setExpressionEngine((ExpressionEngine)expressionEngine);
                }
                catch (InterpolationException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            } else {
                this.logger.debug("Creating a default configuration - no configuration was provided");
                configuration = new CombinedConfiguration();
            }
            configuration.addConfiguration((AbstractConfiguration)new SystemConfiguration());
            this.configuration = configuration;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public Registry getSection(String name) {
        CombinedConfiguration combinedConfiguration = (CombinedConfiguration)this.configuration;
        Configuration configuration = combinedConfiguration.getConfiguration(name);
        return configuration == null ? null : new CommonsConfigurationRegistry(configuration);
    }

    public String getPropertyDelimiter() {
        return this.propertyDelimiter;
    }

    public void setPropertyDelimiter(String propertyDelimiter) {
        this.propertyDelimiter = propertyDelimiter;
    }
}

