/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.api.services;

import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.maven2.model.TreeEntry;
import org.apache.archiva.metadata.model.ProjectVersionMetadata;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.rest.api.model.ArtifactContent;
import org.apache.archiva.rest.api.model.ArtifactContentEntry;
import org.apache.archiva.rest.api.model.BrowseResult;
import org.apache.archiva.rest.api.model.Entry;
import org.apache.archiva.rest.api.model.MetadataAddRequest;
import org.apache.archiva.rest.api.model.VersionsList;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;

@Path(value="/browseService/")
public interface BrowseService {
    @Path(value="rootGroups")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public BrowseResult getRootGroups(@QueryParam(value="repositoryId") String var1) throws ArchivaRestServiceException;

    @Path(value="browseGroupId/{groupId}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public BrowseResult browseGroupId(@PathParam(value="groupId") String var1, @QueryParam(value="repositoryId") String var2) throws ArchivaRestServiceException;

    @Path(value="versionsList/{g}/{a}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public VersionsList getVersionsList(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @QueryParam(value="repositoryId") String var3) throws ArchivaRestServiceException;

    @Path(value="projectVersionMetadata/{g}/{a}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public ProjectVersionMetadata getProjectVersionMetadata(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @QueryParam(value="repositoryId") String var3) throws ArchivaRestServiceException;

    @Path(value="projectVersionMetadata/{g}/{a}/{v}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public ProjectVersionMetadata getProjectMetadata(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @QueryParam(value="repositoryId") String var4) throws ArchivaRestServiceException;

    @Path(value="userRepositories")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<ManagedRepository> getUserRepositories() throws ArchivaRestServiceException;

    @Path(value="userManagableRepositories")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<ManagedRepository> getUserManagableRepositories() throws ArchivaRestServiceException;

    @Path(value="treeEntries/{g}/{a}/{v}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<TreeEntry> getTreeEntries(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @QueryParam(value="repositoryId") String var4) throws ArchivaRestServiceException;

    @Path(value="dependees/{g}/{a}/{v}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> getDependees(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @QueryParam(value="repositoryId") String var4) throws ArchivaRestServiceException;

    @Path(value="metadatas/{g}/{a}/{v}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Entry> getMetadatas(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @QueryParam(value="repositoryId") String var4) throws ArchivaRestServiceException;

    @Path(value="metadata/{g}/{a}/{v}/{key}/{value}")
    @PUT
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=false, noRestriction=false, permissions={"archiva-add-metadata"})
    public Boolean addMetadata(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @PathParam(value="key") String var4, @PathParam(value="value") String var5, @QueryParam(value="repositoryId") String var6) throws ArchivaRestServiceException;

    @Path(value="metadata/{g}/{a}/{v}/{key}")
    @DELETE
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=false, noRestriction=false, permissions={"archiva-add-metadata"})
    public Boolean deleteMetadata(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @PathParam(value="key") String var4, @QueryParam(value="repositoryId") String var5) throws ArchivaRestServiceException;

    @Path(value="importMetadata")
    @POST
    @RedbackAuthorization(noPermission=false, noRestriction=false, permissions={"archiva-add-metadata"})
    public Boolean importMetadata(MetadataAddRequest var1, @QueryParam(value="repository") String var2) throws ArchivaRestServiceException;

    @Path(value="artifactContentEntries/{g}/{a}/{v}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<ArtifactContentEntry> getArtifactContentEntries(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @QueryParam(value="c") String var4, @QueryParam(value="t") String var5, @QueryParam(value="p") String var6, @QueryParam(value="repositoryId") String var7) throws ArchivaRestServiceException;

    @Path(value="artifactDownloadInfos/{g}/{a}/{v}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> getArtifactDownloadInfos(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @QueryParam(value="repositoryId") String var4) throws ArchivaRestServiceException;

    @Path(value="artifactContentText/{g}/{a}/{v}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public ArtifactContent getArtifactContentText(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @QueryParam(value="c") String var4, @QueryParam(value="t") String var5, @QueryParam(value="p") String var6, @QueryParam(value="repositoryId") String var7) throws ArchivaRestServiceException;

    @Path(value="artifactAvailable/{g}/{a}/{v}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public Boolean artifactAvailable(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @QueryParam(value="repositoryId") String var4) throws ArchivaRestServiceException;

    @Path(value="artifactAvailable/{g}/{a}/{v}/{c}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public Boolean artifactAvailable(@PathParam(value="g") String var1, @PathParam(value="a") String var2, @PathParam(value="v") String var3, @PathParam(value="c") String var4, @QueryParam(value="repositoryId") String var5) throws ArchivaRestServiceException;

    @Path(value="artifacts/{r}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> getArtifacts(@PathParam(value="r") String var1) throws ArchivaRestServiceException;

    @Path(value="artifactsByProjectVersionMetadata/{key}/{value}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> getArtifactsByProjectVersionMetadata(@PathParam(value="key") String var1, @PathParam(value="value") String var2, @QueryParam(value="repositoryId") String var3) throws ArchivaRestServiceException;

    @Path(value="artifactsByMetadata/{key}/{value}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> getArtifactsByMetadata(@PathParam(value="key") String var1, @PathParam(value="value") String var2, @QueryParam(value="repositoryId") String var3) throws ArchivaRestServiceException;

    @Path(value="artifactsByProperty/{key}/{value}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> getArtifactsByProperty(@PathParam(value="key") String var1, @PathParam(value="value") String var2, @QueryParam(value="repositoryId") String var3) throws ArchivaRestServiceException;

    @Path(value="searchArtifacts/{text}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> searchArtifacts(@PathParam(value="text") String var1, @QueryParam(value="repositoryId") String var2, @QueryParam(value="exact") Boolean var3) throws ArchivaRestServiceException;

    @Path(value="searchArtifacts/{key}/{text}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(noPermission=true, noRestriction=true)
    public List<Artifact> searchArtifacts(@PathParam(value="key") String var1, @PathParam(value="text") String var2, @QueryParam(value="repositoryId") String var3, @QueryParam(value="exact") Boolean var4) throws ArchivaRestServiceException;
}

