/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rbac.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.archiva.redback.common.ldap.MappingException;
import org.apache.archiva.redback.common.ldap.connection.LdapConnection;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionFactory;
import org.apache.archiva.redback.common.ldap.connection.LdapException;
import org.apache.archiva.redback.common.ldap.role.LdapRoleMapper;
import org.apache.archiva.redback.common.ldap.role.LdapRoleMapperConfiguration;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.rbac.AbstractRBACManager;
import org.apache.archiva.redback.rbac.AbstractRole;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RBACManagerListener;
import org.apache.archiva.redback.rbac.RBACObjectAssertions;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.RbacObjectInvalidException;
import org.apache.archiva.redback.rbac.RbacObjectNotFoundException;
import org.apache.archiva.redback.rbac.RbacPermanentException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.ldap.ctl.LdapController;
import org.apache.archiva.redback.users.ldap.ctl.LdapControllerException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rbacManager#ldap")
public class LdapRbacManager
extends AbstractRBACManager
implements RBACManager,
RBACManagerListener {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    @Named(value="rbacManager#cached")
    private RBACManager rbacImpl;
    @Inject
    @Named(value="ldapRoleMapper#default")
    private LdapRoleMapper ldapRoleMapper;
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration userConf;
    @Inject
    @Named(value="userManager#ldap")
    private UserManager userManager;
    @Inject
    private LdapConnectionFactory ldapConnectionFactory;
    @Inject
    private LdapController ldapController;
    @Inject
    @Named(value="ldapRoleMapperConfiguration#default")
    private LdapRoleMapperConfiguration ldapRoleMapperConfiguration;
    @Inject
    @Named(value="cache#ldapRoles")
    private Cache<String, Role> rolesCache;
    @Inject
    @Named(value="cache#userAssignments")
    private Cache<String, UserAssignment> userAssignmentsCache;
    private boolean writableLdap = false;

    @PostConstruct
    public void initialize() {
        this.writableLdap = this.userConf.getBoolean("ldap.config.writable", this.writableLdap);
    }

    public void addChildRole(Role role, Role childRole) throws RbacObjectInvalidException, RbacManagerException {
        this.rbacImpl.addChildRole(role, childRole);
    }

    public void addListener(RBACManagerListener listener) {
        super.addListener(listener);
        this.rbacImpl.addListener(listener);
    }

    public Operation createOperation(String name) throws RbacManagerException {
        return this.rbacImpl.createOperation(name);
    }

    public Permission createPermission(String name) throws RbacManagerException {
        return this.rbacImpl.createPermission(name);
    }

    public Permission createPermission(String name, String operationName, String resourceIdentifier) throws RbacManagerException {
        return this.rbacImpl.createPermission(name, operationName, resourceIdentifier);
    }

    public Resource createResource(String identifier) throws RbacManagerException {
        return this.rbacImpl.createResource(identifier);
    }

    public Role createRole(String name) {
        return this.rbacImpl.createRole(name);
    }

    public UserAssignment createUserAssignment(String username) throws RbacManagerException {
        return this.rbacImpl.createUserAssignment(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void eraseDatabase() {
        if (this.writableLdap) {
            LdapConnection ldapConnection = null;
            DirContext context = null;
            try {
                ldapConnection = this.ldapConnectionFactory.getConnection();
                context = ldapConnection.getDirContext();
                this.ldapRoleMapper.removeAllRoles(context);
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
            }
            catch (MappingException e) {
                this.log.warn("skip error removing all roles {}", (Object)e.getMessage());
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
            }
            catch (LdapException e2) {
                this.log.warn("skip error removing all roles {}", (Object)e2.getMessage());
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
                {
                    catch (Throwable throwable) {
                        this.closeContext(context);
                        this.closeLdapConnection(ldapConnection);
                        throw throwable;
                    }
                }
            }
        }
        this.rolesCache.clear();
        this.userAssignmentsCache.clear();
        this.rbacImpl.eraseDatabase();
    }

    public List<Role> getAllAssignableRoles() throws RbacManagerException {
        try {
            Collection roleNames = this.ldapRoleMapperConfiguration.getLdapGroupMappings().values();
            HashSet<RoleImpl> roles = new HashSet<RoleImpl>();
            for (Collection names : roleNames) {
                for (String name : names) {
                    roles.add(new RoleImpl(name));
                }
            }
            return new ArrayList<Role>(roles);
        }
        catch (MappingException e) {
            throw new RbacManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Operation> getAllOperations() throws RbacManagerException {
        return this.rbacImpl.getAllOperations();
    }

    public List<Permission> getAllPermissions() throws RbacManagerException {
        return this.rbacImpl.getAllPermissions();
    }

    public List<Resource> getAllResources() throws RbacManagerException {
        return this.rbacImpl.getAllResources();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Role> getAllRoles() throws RbacManagerException {
        LdapConnection ldapConnection = null;
        DirContext context = null;
        try {
            ldapConnection = this.ldapConnectionFactory.getConnection();
            context = ldapConnection.getDirContext();
            List groups = this.ldapRoleMapper.getAllGroups(context);
            List<Role> list = this.mapToRoles(groups);
            this.closeContext(context);
            this.closeLdapConnection(ldapConnection);
            return list;
        }
        catch (MappingException e) {
            try {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
                catch (LdapException e2) {
                    throw new RbacManagerException(e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<UserAssignment> getAllUserAssignments() throws RbacManagerException {
        LdapConnection ldapConnection = null;
        DirContext context = null;
        try {
            ldapConnection = this.ldapConnectionFactory.getConnection();
            context = ldapConnection.getDirContext();
            Map usersWithRoles = this.ldapController.findUsersWithRoles(context);
            ArrayList<UserAssignmentImpl> userAssignments = new ArrayList<UserAssignmentImpl>(usersWithRoles.size());
            Object object = usersWithRoles.entrySet().iterator();
            while (true) {
                if (!object.hasNext()) {
                    object = userAssignments;
                    this.closeContext(context);
                    this.closeLdapConnection(ldapConnection);
                    return object;
                }
                Map.Entry entry = object.next();
                UserAssignmentImpl userAssignment = new UserAssignmentImpl((String)entry.getKey(), (Collection)entry.getValue());
                userAssignments.add(userAssignment);
                this.userAssignmentsCache.put((Object)userAssignment.getPrincipal(), (Object)userAssignment);
            }
        }
        catch (LdapControllerException e) {
            try {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
                catch (LdapException e2) {
                    throw new RbacManagerException(e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
                throw throwable;
            }
        }
    }

    protected void closeLdapConnection(LdapConnection ldapConnection) {
        if (ldapConnection != null) {
            ldapConnection.close();
        }
    }

    protected void closeContext(DirContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException e) {
                this.log.warn("skip issue closing context: {}", (Object)e.getMessage());
            }
        }
    }

    private List<Role> mapToRoles(List<String> groups) throws MappingException, RbacManagerException {
        if (groups == null || groups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Role> roles = new ArrayList<Role>(groups.size());
        Map mappedGroups = this.ldapRoleMapperConfiguration.getLdapGroupMappings();
        for (String group : groups) {
            Collection roleNames = (Collection)mappedGroups.get(group);
            if (roleNames != null) {
                for (String roleName : roleNames) {
                    Role role = this.buildRole(roleName);
                    roles.add(role);
                }
                continue;
            }
            if (!this.ldapRoleMapper.isUseDefaultRoleName()) continue;
            Role role = this.buildRole(group);
            roles.add(role);
        }
        return roles;
    }

    private Role buildRole(String group) throws RbacManagerException {
        Role role = null;
        try {
            role = this.rbacImpl.getRole(group);
        }
        catch (RbacObjectNotFoundException rbacObjectNotFoundException) {
            // empty catch block
        }
        Object object = role = role == null ? new RoleImpl(group) : role;
        if (role != null) {
            this.rolesCache.put((Object)role.getName(), (Object)role);
        }
        return role;
    }

    protected List<String> getRealRoles() throws RbacManagerException {
        List roles = this.rbacImpl.getAllRoles();
        ArrayList<String> roleNames = new ArrayList<String>(roles.size());
        for (Role role : roles) {
            roleNames.add(role.getName());
        }
        return roleNames;
    }

    public Collection<Role> getAssignedRoles(String username) throws RbacManagerException {
        LdapConnection ldapConnection = null;
        DirContext context = null;
        try {
            ldapConnection = this.ldapConnectionFactory.getConnection();
            context = ldapConnection.getDirContext();
            List roleNames = this.ldapRoleMapper.getRoles(username, context, this.getRealRoles());
            if (roleNames.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Role> roles = new ArrayList<Role>(roleNames.size());
            for (String name : roleNames) {
                roles.add(this.rbacImpl.getRole(name));
            }
            return roles;
        }
        catch (MappingException e) {
            throw new RbacManagerException(e.getMessage(), (Throwable)e);
        }
        catch (LdapException e) {
            throw new RbacManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<Role> getAssignedRoles(UserAssignment userAssignment) throws RbacManagerException {
        return this.getAssignedRoles(userAssignment.getPrincipal());
    }

    public Map<String, Role> getChildRoles(Role role) throws RbacManagerException {
        return this.rbacImpl.getChildRoles(role);
    }

    public Map<String, Role> getParentRoles(Role role) throws RbacManagerException {
        return this.rbacImpl.getParentRoles(role);
    }

    public Set<Role> getEffectiveRoles(Role role) throws RbacManagerException {
        return this.rbacImpl.getEffectiveRoles(role);
    }

    public Resource getGlobalResource() throws RbacManagerException {
        return this.rbacImpl.getGlobalResource();
    }

    public Operation getOperation(String operationName) throws RbacManagerException {
        return this.rbacImpl.getOperation(operationName);
    }

    public Permission getPermission(String permissionName) throws RbacManagerException {
        return this.rbacImpl.getPermission(permissionName);
    }

    public Resource getResource(String resourceIdentifier) throws RbacManagerException {
        return this.rbacImpl.getResource(resourceIdentifier);
    }

    public Role getRole(String roleName) throws RbacManagerException {
        Role role = (Role)this.rolesCache.get((Object)roleName);
        if (role != null) {
            return role;
        }
        LdapConnection ldapConnection = null;
        DirContext context = null;
        try {
            ldapConnection = this.ldapConnectionFactory.getConnection();
            context = ldapConnection.getDirContext();
            if (!this.ldapRoleMapper.hasRole(context, roleName)) {
                return null;
            }
        }
        catch (MappingException e) {
            throw new RbacManagerException(e.getMessage(), (Throwable)e);
        }
        catch (LdapException e) {
            throw new RbacManagerException(e.getMessage(), (Throwable)e);
        }
        role = this.rbacImpl.getRole(roleName);
        role = role == null ? new RoleImpl(roleName) : role;
        this.rolesCache.put((Object)roleName, (Object)role);
        return role;
    }

    public Map<String, Role> getRoles(Collection<String> roleNames) throws RbacManagerException {
        return this.rbacImpl.getRoles(roleNames);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Role> getUnassignedRoles(String username) throws RbacManagerException {
        LdapConnection ldapConnection = null;
        DirContext context = null;
        try {
            ldapConnection = this.ldapConnectionFactory.getConnection();
            context = ldapConnection.getDirContext();
            List allRoles = this.ldapRoleMapper.getAllRoles(context);
            List userRoles = this.ldapRoleMapper.getRoles(username, context, this.getRealRoles());
            ArrayList<Role> unassignedRoles = new ArrayList<Role>();
            Object object = allRoles.iterator();
            while (true) {
                if (!object.hasNext()) {
                    object = unassignedRoles;
                    this.closeContext(context);
                    this.closeLdapConnection(ldapConnection);
                    return object;
                }
                String roleName = (String)object.next();
                if (userRoles.contains(roleName)) continue;
                unassignedRoles.add(this.rbacImpl.getRole(roleName));
            }
        }
        catch (MappingException e) {
            try {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
                catch (LdapException e2) {
                    throw new RbacManagerException(e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserAssignment getUserAssignment(String username) throws RbacManagerException {
        UserAssignment ua = (UserAssignment)this.userAssignmentsCache.get((Object)username);
        if (ua != null) {
            return ua;
        }
        LdapConnection ldapConnection = null;
        DirContext context = null;
        try {
            ldapConnection = this.ldapConnectionFactory.getConnection();
            context = ldapConnection.getDirContext();
            List roles = this.ldapRoleMapper.getRoles(username, context, this.getRealRoles());
            ua = new UserAssignmentImpl(username, roles);
            this.userAssignmentsCache.put((Object)username, (Object)ua);
            UserAssignment userAssignment = ua;
            this.closeContext(context);
            this.closeLdapConnection(ldapConnection);
            return userAssignment;
        }
        catch (MappingException e) {
            try {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
                catch (LdapException e2) {
                    throw new RbacManagerException(e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
                throw throwable;
            }
        }
    }

    public List<UserAssignment> getUserAssignmentsForRoles(Collection<String> roleNames) throws RbacManagerException {
        return this.rbacImpl.getUserAssignmentsForRoles(roleNames);
    }

    public boolean operationExists(Operation operation) {
        return this.rbacImpl.operationExists(operation);
    }

    public boolean operationExists(String name) {
        return this.rbacImpl.operationExists(name);
    }

    public boolean permissionExists(Permission permission) {
        return this.rbacImpl.permissionExists(permission);
    }

    public boolean permissionExists(String name) {
        return this.rbacImpl.permissionExists(name);
    }

    public void rbacInit(boolean freshdb) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacInit(freshdb);
        }
    }

    public void rbacPermissionRemoved(Permission permission) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacPermissionRemoved(permission);
        }
    }

    public void rbacPermissionSaved(Permission permission) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacPermissionSaved(permission);
        }
    }

    public void rbacRoleRemoved(Role role) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacRoleRemoved(role);
        }
    }

    public void rbacRoleSaved(Role role) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacRoleSaved(role);
        }
    }

    public void rbacUserAssignmentRemoved(UserAssignment userAssignment) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacUserAssignmentRemoved(userAssignment);
        }
    }

    public void rbacUserAssignmentSaved(UserAssignment userAssignment) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacUserAssignmentSaved(userAssignment);
        }
    }

    public void removeListener(RBACManagerListener listener) {
        this.rbacImpl.removeListener(listener);
    }

    public void removeOperation(Operation operation) throws RbacManagerException {
        this.rbacImpl.removeOperation(operation);
    }

    public void removeOperation(String operationName) throws RbacManagerException {
        this.rbacImpl.removeOperation(operationName);
    }

    public void removePermission(Permission permission) throws RbacManagerException {
        this.rbacImpl.removePermission(permission);
    }

    public void removePermission(String permissionName) throws RbacManagerException {
        this.rbacImpl.removePermission(permissionName);
    }

    public void removeResource(Resource resource) throws RbacManagerException {
        this.rbacImpl.removeResource(resource);
    }

    public void removeResource(String resourceIdentifier) throws RbacManagerException {
        this.rbacImpl.removeResource(resourceIdentifier);
    }

    public void removeRole(Role role) throws RbacManagerException {
        RBACObjectAssertions.assertValid((Role)role);
        if (role.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent role [" + role.getName() + "]");
        }
        this.rolesCache.remove((Object)role.getName());
        if (this.writableLdap) {
            LdapConnection ldapConnection = null;
            DirContext context = null;
            try {
                ldapConnection = this.ldapConnectionFactory.getConnection();
                context = ldapConnection.getDirContext();
                this.ldapRoleMapper.removeRole(role.getName(), context);
            }
            catch (MappingException e) {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
            }
            catch (LdapException e) {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
            }
            this.fireRbacRoleRemoved(role);
        }
    }

    public void removeRole(String roleName) throws RbacManagerException {
        if (roleName == null) {
            return;
        }
        this.removeRole((Role)new RoleImpl(roleName));
    }

    public void removeUserAssignment(String username) throws RbacManagerException {
        this.userAssignmentsCache.remove((Object)username);
        this.rbacImpl.removeUserAssignment(username);
    }

    public void removeUserAssignment(UserAssignment userAssignment) throws RbacManagerException {
        if (userAssignment != null) {
            this.userAssignmentsCache.remove((Object)userAssignment.getPrincipal());
        }
        this.rbacImpl.removeUserAssignment(userAssignment);
    }

    public boolean resourceExists(Resource resource) {
        return this.rbacImpl.resourceExists(resource);
    }

    public boolean resourceExists(String identifier) {
        return this.rbacImpl.resourceExists(identifier);
    }

    public boolean roleExists(Role role) throws RbacManagerException {
        if (role == null) {
            return false;
        }
        return this.roleExists(role.getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean roleExists(String name) throws RbacManagerException {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        if (this.rolesCache.get((Object)name) != null) {
            return true;
        }
        LdapConnection ldapConnection = null;
        DirContext context = null;
        try {
            ldapConnection = this.ldapConnectionFactory.getConnection();
            context = ldapConnection.getDirContext();
            if (this.rolesCache.hasKey((Object)name)) {
                boolean bl = true;
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
                return bl;
            }
        }
        catch (MappingException e) {
            try {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
                catch (LdapException e2) {
                    throw new RbacManagerException(e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
                throw throwable;
            }
        }
        {
            boolean bl = this.ldapRoleMapper.hasRole(context, name);
            this.closeContext(context);
            this.closeLdapConnection(ldapConnection);
            return bl;
        }
    }

    public Operation saveOperation(Operation operation) throws RbacManagerException {
        return this.rbacImpl.saveOperation(operation);
    }

    public Permission savePermission(Permission permission) throws RbacManagerException {
        return this.rbacImpl.savePermission(permission);
    }

    public Resource saveResource(Resource resource) throws RbacManagerException {
        return this.rbacImpl.saveResource(resource);
    }

    public synchronized Role saveRole(Role role) throws RbacManagerException {
        if (this.writableLdap) {
            LdapConnection ldapConnection = null;
            DirContext context = null;
            try {
                ldapConnection = this.ldapConnectionFactory.getConnection();
                context = ldapConnection.getDirContext();
                this.ldapRoleMapper.saveRole(role.getName(), context);
                if (!role.getChildRoleNames().isEmpty()) {
                    for (String roleName : role.getChildRoleNames()) {
                        this.ldapRoleMapper.saveRole(roleName, context);
                    }
                }
                this.fireRbacRoleSaved(role);
            }
            catch (MappingException e) {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
            }
            catch (LdapException e) {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
            }
        }
        role = this.rbacImpl.saveRole(role);
        this.rolesCache.put((Object)role.getName(), (Object)role);
        return role;
    }

    public synchronized void saveRoles(Collection<Role> roles) throws RbacManagerException {
        if (this.writableLdap) {
            LdapConnection ldapConnection = null;
            DirContext context = null;
            try {
                ldapConnection = this.ldapConnectionFactory.getConnection();
                context = ldapConnection.getDirContext();
                for (Role role : roles) {
                    this.ldapRoleMapper.saveRole(role.getName(), context);
                    this.fireRbacRoleSaved(role);
                }
            }
            catch (MappingException e) {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
            }
            catch (LdapException e) {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
            }
        }
        this.rbacImpl.saveRoles(roles);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserAssignment saveUserAssignment(UserAssignment userAssignment) throws RbacManagerException {
        LdapConnection ldapConnection = null;
        DirContext context = null;
        try {
            if (!this.userManager.userExists(userAssignment.getPrincipal())) {
                User user = this.userManager.createUser(userAssignment.getPrincipal(), null, null);
                this.userManager.addUser(user);
            }
            ldapConnection = this.ldapConnectionFactory.getConnection();
            context = ldapConnection.getDirContext();
            List allRoles = this.ldapRoleMapper.getAllRoles(context);
            List currentUserRoles = this.ldapRoleMapper.getRoles(userAssignment.getPrincipal(), context, this.getRealRoles());
            for (String role : userAssignment.getRoleNames()) {
                if (currentUserRoles.contains(role) || !this.writableLdap) continue;
                if (!allRoles.contains(role)) {
                    this.ldapRoleMapper.saveRole(role, context);
                    allRoles.add(role);
                }
                this.ldapRoleMapper.saveUserRole(role, userAssignment.getPrincipal(), context);
                currentUserRoles.add(role);
            }
            UserAssignment userAssignment2 = currentUserRoles.iterator();
            while (true) {
                String role;
                if (!userAssignment2.hasNext()) {
                    this.userAssignmentsCache.put((Object)userAssignment.getPrincipal(), (Object)userAssignment);
                    userAssignment2 = userAssignment;
                    this.closeContext(context);
                    this.closeLdapConnection(ldapConnection);
                    return userAssignment2;
                }
                role = (String)userAssignment2.next();
                if (userAssignment.getRoleNames().contains(role) || !this.writableLdap) continue;
                this.ldapRoleMapper.removeUserRole(role, userAssignment.getPrincipal(), context);
            }
        }
        catch (UserManagerException e) {
            try {
                throw new RbacManagerException(e.getMessage(), (Throwable)e);
                catch (MappingException e2) {
                    throw new RbacManagerException(e2.getMessage(), (Throwable)e2);
                }
                catch (LdapException e3) {
                    throw new RbacManagerException(e3.getMessage(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                this.closeContext(context);
                this.closeLdapConnection(ldapConnection);
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean userAssignmentExists(String principal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean userAssignmentExists(UserAssignment assignment) {
        if (assignment == null) {
            return false;
        }
        return this.userAssignmentExists(assignment.getPrincipal());
    }

    public RBACManager getRbacImpl() {
        return this.rbacImpl;
    }

    public void setRbacImpl(RBACManager rbacImpl) {
        this.rbacImpl = rbacImpl;
    }

    public boolean isWritableLdap() {
        return this.writableLdap;
    }

    public void setWritableLdap(boolean writableLdap) {
        this.writableLdap = writableLdap;
    }

    public LdapRoleMapper getLdapRoleMapper() {
        return this.ldapRoleMapper;
    }

    public void setLdapRoleMapper(LdapRoleMapper ldapRoleMapper) {
        this.ldapRoleMapper = ldapRoleMapper;
    }

    public boolean isFinalImplementation() {
        return true;
    }

    public String getDescriptionKey() {
        return "archiva.redback.rbacmanager.ldap";
    }

    public boolean isReadOnly() {
        return !this.writableLdap;
    }

    private static class UserAssignmentImpl
    implements UserAssignment {
        private String username;
        private List<String> roleNames;
        private boolean permanent;

        private UserAssignmentImpl(String username, Collection<String> roleNames) {
            this.username = username;
            this.roleNames = roleNames == null ? new ArrayList<String>() : new ArrayList<String>(roleNames);
        }

        public String getPrincipal() {
            return this.username;
        }

        public List<String> getRoleNames() {
            return this.roleNames;
        }

        public void addRoleName(Role role) {
            if (role == null) {
                return;
            }
            this.roleNames.add(role.getName());
        }

        public void addRoleName(String roleName) {
            if (roleName == null) {
                return;
            }
            this.roleNames.add(roleName);
        }

        public void removeRoleName(Role role) {
            if (role == null) {
                return;
            }
            this.roleNames.remove(role.getName());
        }

        public void removeRoleName(String roleName) {
            if (roleName == null) {
                return;
            }
            this.roleNames.remove(roleName);
        }

        public void setPrincipal(String principal) {
            this.username = principal;
        }

        public void setRoleNames(List<String> roles) {
            this.roleNames = roles;
        }

        public boolean isPermanent() {
            return this.permanent;
        }

        public void setPermanent(boolean permanent) {
            this.permanent = permanent;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UserAssignmentImpl");
            sb.append("{username='").append(this.username).append('\'');
            sb.append(", roleNames=").append(this.roleNames);
            sb.append(", permanent=").append(this.permanent);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class RoleImpl
    extends AbstractRole {
        private String name;
        private String description;
        private List<Permission> permissions = new ArrayList<Permission>();
        private List<String> childRoleNames = new ArrayList<String>();

        private RoleImpl(String name) {
            this.name = name;
        }

        private RoleImpl(String name, List<Permission> permissions) {
            this.name = name;
            this.permissions = permissions;
        }

        public void addPermission(Permission permission) {
            this.permissions.add(permission);
        }

        public void addChildRoleName(String name) {
            this.childRoleNames.add(name);
        }

        public List<String> getChildRoleNames() {
            return this.childRoleNames;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public List<Permission> getPermissions() {
            return this.permissions;
        }

        public boolean isAssignable() {
            return true;
        }

        public void removePermission(Permission permission) {
            this.permissions.remove(permission);
        }

        public void setAssignable(boolean assignable) {
        }

        public void setChildRoleNames(List<String> names) {
            this.childRoleNames = names;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPermissions(List<Permission> permissions) {
            this.permissions = permissions;
        }

        public boolean isPermanent() {
            return true;
        }

        public void setPermanent(boolean permanent) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("RoleImpl");
            sb.append("{name='").append(this.name).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            RoleImpl role = (RoleImpl)((Object)o);
            return !(this.name != null ? !this.name.equals(role.name) : role.name != null);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }
}

