/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.policies;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.archiva.policies.DownloadErrorPolicy;
import org.apache.archiva.policies.PolicyConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="downloadErrorPolicy#propagate-errors-on-update")
public class PropagateErrorsOnUpdateDownloadPolicy
implements DownloadErrorPolicy {
    public static final String ALWAYS = "always";
    public static final String NOT_PRESENT = "artifact not already present";
    private List<String> options = new ArrayList<String>(2);

    public PropagateErrorsOnUpdateDownloadPolicy() {
        this.options.add(ALWAYS);
        this.options.add(NOT_PRESENT);
    }

    @Override
    public boolean applyPolicy(String policySetting, Properties request, File localFile, Exception exception, Map<String, Exception> previousExceptions) throws PolicyConfigurationException {
        if (!this.options.contains(policySetting)) {
            throw new PolicyConfigurationException("Unknown error policy setting [" + policySetting + "], valid settings are [" + StringUtils.join(this.options.iterator(), (String)",") + "]");
        }
        if (ALWAYS.equals(policySetting)) {
            return true;
        }
        if (NOT_PRESENT.equals(policySetting)) {
            return !localFile.exists();
        }
        throw new PolicyConfigurationException("Unable to process checksum policy of [" + policySetting + "], please file a bug report.");
    }

    @Override
    public String getDefaultOption() {
        return NOT_PRESENT;
    }

    @Override
    public String getId() {
        return "propagate-errors-on-update";
    }

    @Override
    public String getName() {
        return "Return error when";
    }

    @Override
    public List<String> getOptions() {
        return this.options;
    }
}

